/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramPin;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Pin;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.PinDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.PinDTOConverterContext;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BasePinResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.PinResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/pin.properties"}, scope=ServiceScope.PROTOTYPE, service={PinResource.class})
public class PinResourceImpl
extends BasePinResourceImpl {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CSDiagramPinLocalService _csDiagramPinLocalService;
    @Reference
    private PinDTOConverter _pinDTOConverter;

    @Override
    public Page<Pin> getChannelProductPinsPage(Long channelId, Long productId, Long accountId, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        accountId = this._getAccountId(accountId, commerceChannel);
        this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), accountId.longValue(), commerceChannel.getGroupId(), cpDefinition.getCPDefinitionId());
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), this.contextUser.getUserId(), 0L, accountId.longValue());
        return Page.of(this._toPins(commerceContext, this._csDiagramPinLocalService.getCSDiagramPins(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._csDiagramPinLocalService.getCSDiagramPinsCount(cpDefinition.getCPDefinitionId()));
    }

    private Long _getAccountId(Long accountId, CommerceChannel commerceChannel) throws Exception {
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            if (commerceAccountIds.length == 0) {
                CommerceAccount commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(this.contextUser.getCompanyId());
                commerceAccountIds = new long[]{commerceAccount.getCommerceAccountId()};
            }
            return commerceAccountIds[0];
        }
        return accountId;
    }

    private Pin _toPin(CommerceContext commerceContext, long csDiagramPinId) throws Exception {
        return this._pinDTOConverter.toDTO((DTOConverterContext)new PinDTOConverterContext(commerceContext, this.contextCompany.getCompanyId(), csDiagramPinId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<Pin> _toPins(CommerceContext commerceContext, List<CSDiagramPin> csDiagramPins) {
        return this.transform(csDiagramPins, csDiagramPin -> this._toPin(commerceContext, csDiagramPin.getCSDiagramPinId()));
    }
}

