/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.MappedProductDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.MappedProductDTOConverterContext;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseMappedProductResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.MappedProductResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/mapped-product.properties"}, scope=ServiceScope.PROTOTYPE, service={MappedProductResource.class})
public class MappedProductResourceImpl
extends BaseMappedProductResourceImpl {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private MappedProductDTOConverter _mappedProductDTOConverter;

    @Override
    public Page<MappedProduct> getChannelProductMappedProductsPage(Long channelId, Long productId, Long accountId, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        accountId = this._getAccountId(accountId, commerceChannel);
        this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), accountId.longValue(), commerceChannel.getGroupId(), cpDefinition.getCPDefinitionId());
        CommerceContext commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), this.contextUser.getUserId(), 0L, accountId.longValue());
        return this._getMappedProductsPage(commerceContext, cpDefinition.getCPDefinitionId(), pagination, search, sorts);
    }

    private Long _getAccountId(Long accountId, CommerceChannel commerceChannel) throws Exception {
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            if (commerceAccountIds.length == 0) {
                CommerceAccount commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(this.contextUser.getCompanyId());
                commerceAccountIds = new long[]{commerceAccount.getCommerceAccountId()};
            }
            return commerceAccountIds[0];
        }
        return accountId;
    }

    private Page<MappedProduct> _getMappedProductsPage(CommerceContext commerceContext, long cpDefinitionId, Pagination pagination, String search, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> {}, null, (String)CSDiagramEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
            searchContext.setAttribute("CPDefinitionId", (Serializable)Long.valueOf(cpDefinitionId));
        }, (Sort[])sorts, document -> this._toMappedProduct(commerceContext, GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    private MappedProduct _toMappedProduct(CommerceContext commerceContext, long csDiagramEntryId) throws Exception {
        return this._mappedProductDTOConverter.toDTO((DTOConverterContext)new MappedProductDTOConverterContext(commerceContext, this.contextCompany.getCompanyId(), csDiagramEntryId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

