/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.CategoryDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseCategoryResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.CategoryResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/category.properties"}, scope=ServiceScope.PROTOTYPE, service={CategoryResource.class, NestedFieldSupport.class})
public class CategoryResourceImpl
extends BaseCategoryResourceImpl
implements NestedFieldSupport {
    @Reference
    private AssetCategoryService _assetCategoryLocalService;
    @Reference
    private CategoryDTOConverter _categoryDTOConverter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;

    @Override
    @NestedField(parentClass=Product.class, value="categories")
    public Page<Category> getChannelProductCategoriesPage(Long channelId, @NestedFieldId(value="productId") Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        List assetCategories = this._assetCategoryLocalService.getCategories(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._assetCategoryLocalService.getCategoriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductCategories(assetCategories), (Pagination)pagination, (long)totalItems);
    }

    private List<Category> _toProductCategories(List<AssetCategory> assetCategories) throws Exception {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (AssetCategory category : assetCategories) {
            categories.add(this._categoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)category.getCategoryId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return categories;
    }
}

