/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.AttachmentDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.AttachmentDTOConverterContext;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseAttachmentResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.AttachmentResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={AttachmentResource.class, NestedFieldSupport.class})
public class AttachmentResourceImpl
extends BaseAttachmentResourceImpl
implements NestedFieldSupport {
    @Reference
    private AttachmentDTOConverter _attachmentDTOConverter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;

    @Override
    @NestedField(parentClass=Product.class, value="attachments")
    public Page<Attachment> getChannelProductAttachmentsPage(Long channelId, @NestedFieldId(value="productId") Long productId, Long accountId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        return this._getAttachmentPage(cpDefinition, this._getAccountId(accountId, this._commerceChannelLocalService.getCommerceChannel(channelId.longValue())), 1, pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="images")
    public Page<Attachment> getChannelProductImagesPage(Long channelId, @NestedFieldId(value="productId") Long productId, Long accountId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        return this._getAttachmentPage(cpDefinition, this._getAccountId(accountId, this._commerceChannelLocalService.getCommerceChannel(channelId.longValue())), 0, pagination);
    }

    private Long _getAccountId(Long accountId, CommerceChannel commerceChannel) throws Exception {
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            if (commerceAccountIds.length == 0) {
                CommerceAccount commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(this.contextCompany.getCompanyId());
                commerceAccountIds = new long[]{commerceAccount.getCommerceAccountId()};
            }
            return commerceAccountIds[0];
        }
        return accountId;
    }

    private Page<Attachment> _getAttachmentPage(CPDefinition cpDefinition, long accountId, int type, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0, pagination.getStartPosition(), pagination.getEndPosition()), cpAttachmentFileEntry -> this._toAttachment(accountId, (CPAttachmentFileEntry)cpAttachmentFileEntry)), (Pagination)pagination, (long)this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0));
    }

    private Attachment _toAttachment(long accountId, CPAttachmentFileEntry cpAttachmentFileEntry) throws Exception {
        return this._attachmentDTOConverter.toDTO((DTOConverterContext)new AttachmentDTOConverterContext(cpAttachmentFileEntry.getCPAttachmentFileEntryId(), this.contextAcceptLanguage.getPreferredLocale(), accountId));
    }
}

