/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.url.CPFriendlyURL;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.CommerceWishListItemService;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.WishList;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.WishListItem;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.delivery.catalog.dto.v1_0.WishListItem"}, service={DTOConverter.class, WishListItemDTOConverter.class})
public class WishListItemDTOConverter
implements DTOConverter<CommerceContext, WishListItem> {
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CommerceWishListItemService _commerceWishListItemService;
    @Reference
    private CPFriendlyURL _cpFriendlyURL;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public String getContentType() {
        return WishList.class.getSimpleName();
    }

    public WishListItem toDTO(final DTOConverterContext dtoConverterContext, final CommerceContext commerceContext) throws Exception {
        final CommerceWishListItem commerceWishListItem = this._commerceWishListItemService.getCommerceWishListItem(((Long)dtoConverterContext.getId()).longValue());
        return new WishListItem(){
            {
                this.id = commerceWishListItem.getCommerceWishListItemId();
                this.productId = commerceWishListItem.getCProductId();
                this.setFinalPrice(() -> {
                    CPInstance cpInstance = commerceWishListItem.fetchCPInstance();
                    if (cpInstance == null) {
                        return null;
                    }
                    CommerceMoney finalPriceCommerceMoney = WishListItemDTOConverter.this._commerceProductPriceCalculation.getFinalPrice(cpInstance.getCPInstanceId(), 1, commerceContext);
                    if (finalPriceCommerceMoney.isEmpty()) {
                        return null;
                    }
                    return finalPriceCommerceMoney.format(dtoConverterContext.getLocale());
                });
                this.setFriendlyURL(() -> {
                    CPDefinition cpDefinition = commerceWishListItem.getCPDefinition();
                    FriendlyURLEntry friendlyURLEntry = WishListItemDTOConverter.this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(WishListItemDTOConverter.this._portal.getClassNameId(CProduct.class), cpDefinition.getCProductId());
                    String productURLSeparator = WishListItemDTOConverter.this._cpFriendlyURL.getProductURLSeparator(cpDefinition.getCompanyId());
                    String urlTitle = friendlyURLEntry.getUrlTitle(WishListItemDTOConverter.this._language.getLanguageId(dtoConverterContext.getLocale()));
                    return productURLSeparator + urlTitle;
                });
                this.setIcon(() -> {
                    CPDefinition cpDefinition = commerceWishListItem.getCPDefinition();
                    CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
                    return cpDefinition.getDefaultImageThumbnailSrc(commerceAccount.getCommerceAccountId());
                });
                this.setProductName(() -> {
                    CPDefinition cpDefinition = commerceWishListItem.getCPDefinition();
                    return cpDefinition.getName(WishListItemDTOConverter.this._language.getLanguageId(dtoConverterContext.getLocale()));
                });
                this.setSkuId(() -> {
                    CPInstance cpInstance = commerceWishListItem.fetchCPInstance();
                    if (cpInstance == null) {
                        return null;
                    }
                    return cpInstance.getCPInstanceId();
                });
            }
        };
    }
}

