/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Availability;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Price;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.SkuDTOConverterContext;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=CPSku"}, service={DTOConverter.class, SkuDTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CPDefinitionInventoryEngine _cpDefinitionInventoryEngine;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private JsonHelper _jsonHelper;
    @Reference
    private Language _language;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final SkuDTOConverterContext cpSkuDTOConverterConvertContext = (SkuDTOConverterContext)dtoConverterContext;
        final CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(((Long)cpSkuDTOConverterConvertContext.getId()).longValue());
        final CommerceContext commerceContext = cpSkuDTOConverterConvertContext.getCommerceContext();
        return new Sku(){
            {
                this.availability = SkuDTOConverter.this._getAvailability(commerceContext.getCommerceChannelGroupId(), cpSkuDTOConverterConvertContext.getCompanyId(), cpInstance.getSku(), cpInstance, cpSkuDTOConverterConvertContext.getLocale());
                this.depth = cpInstance.getDepth();
                this.displayDate = cpInstance.getDisplayDate();
                this.expirationDate = cpInstance.getExpirationDate();
                this.gtin = cpInstance.getGtin();
                this.height = cpInstance.getHeight();
                this.id = cpInstance.getCPInstanceId();
                this.manufacturerPartNumber = cpInstance.getManufacturerPartNumber();
                this.price = SkuDTOConverter.this._getPrice(cpInstance, 1, cpSkuDTOConverterConvertContext.getCommerceContext(), cpSkuDTOConverterConvertContext.getLocale());
                this.published = cpInstance.isPublished();
                this.purchasable = cpInstance.isPurchasable();
                this.sku = cpInstance.getSku();
                this.skuOptions = SkuDTOConverter.this._getSkuOptions(cpInstance);
                this.weight = cpInstance.getWeight();
                this.width = cpInstance.getWidth();
            }
        };
    }

    private Availability _getAvailability(long commerceChannelGroupId, long companyId, String sku, CPInstance cpInstance, Locale locale) throws Exception {
        Availability availability = new Availability();
        if (this._cpDefinitionInventoryEngine.isDisplayAvailability(cpInstance)) {
            if (Objects.equals(this._commerceInventoryEngine.getAvailabilityStatus(cpInstance.getCompanyId(), commerceChannelGroupId, this._cpDefinitionInventoryEngine.getMinStockQuantity(cpInstance), cpInstance.getSku()), "available")) {
                availability.setLabel_i18n(this._language.get(locale, "available"));
                availability.setLabel("available");
            } else {
                availability.setLabel_i18n(this._language.get(locale, "unavailable"));
                availability.setLabel("unavailable");
            }
        }
        if (this._cpDefinitionInventoryEngine.isDisplayStockQuantity(cpInstance)) {
            availability.setStockQuantity(Integer.valueOf(this._commerceInventoryEngine.getStockQuantity(companyId, commerceChannelGroupId, sku)));
        }
        return availability;
    }

    private String[] _getFormattedDiscountPercentages(BigDecimal[] discountPercentages, Locale locale) throws Exception {
        ArrayList<String> formattedDiscountPercentages = new ArrayList<String>();
        for (BigDecimal percentage : discountPercentages) {
            formattedDiscountPercentages.add(this._commercePriceFormatter.format(percentage, locale));
        }
        return formattedDiscountPercentages.toArray(new String[0]);
    }

    private Price _getPrice(CPInstance cpInstance, int quantity, CommerceContext commerceContext, final Locale locale) throws Exception {
        CommerceDiscountValue discountValue;
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(cpInstance.getCPInstanceId(), quantity, true, commerceContext);
        if (commerceProductPrice == null) {
            return new Price();
        }
        final CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        final CommerceMoney unitPriceCommerceMoney = commerceProductPrice.getUnitPrice();
        CommerceMoney unitPromoPriceCommerceMoney = commerceProductPrice.getUnitPromoPrice();
        BigDecimal unitPromoPrice = unitPromoPriceCommerceMoney.getPrice();
        final BigDecimal unitPrice = unitPriceCommerceMoney.getPrice();
        Price price = new Price(){
            {
                this.currency = commerceCurrency.getName(locale);
                this.price = unitPrice.doubleValue();
                this.priceFormatted = unitPriceCommerceMoney.format(locale);
            }
        };
        if (unitPromoPrice != null && unitPromoPrice.compareTo(BigDecimal.ZERO) > 0 && unitPromoPrice.compareTo(unitPriceCommerceMoney.getPrice()) < 0) {
            price.setPromoPrice(Double.valueOf(unitPromoPrice.doubleValue()));
            price.setPromoPriceFormatted(unitPromoPriceCommerceMoney.format(locale));
        }
        if ((discountValue = commerceProductPrice.getDiscountValue()) != null) {
            CommerceMoney discountAmountCommerceMoney = discountValue.getDiscountAmount();
            CommerceMoney finalPriceCommerceMoney = commerceProductPrice.getFinalPrice();
            price.setDiscount(discountAmountCommerceMoney.format(locale));
            price.setDiscountPercentage(this._commercePriceFormatter.format(discountValue.getDiscountPercentage(), locale));
            price.setDiscountPercentages(this._getFormattedDiscountPercentages(discountValue.getPercentages(), locale));
            price.setFinalPrice(finalPriceCommerceMoney.format(locale));
        }
        return price;
    }

    private SkuOption[] _getSkuOptions(CPInstance cpInstance) throws Exception {
        ArrayList<3> skuOptions = new ArrayList<3>();
        JSONArray keyValuesJSONArray = this._jsonHelper.toJSONArray(this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstance.getCPInstanceId()));
        Map cpDefinitionOptionRelsMap = this._cpInstanceHelper.getCPDefinitionOptionValueRelsMap(cpInstance.getCPDefinitionId(), keyValuesJSONArray.toString());
        for (Map.Entry entry : cpDefinitionOptionRelsMap.entrySet()) {
            final CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)entry.getKey();
            List cpDefinitionOptionValueRels = (List)entry.getValue();
            for (final CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                SkuOption skuOption = new SkuOption(){
                    {
                        this.key = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                        this.value = cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId();
                    }
                };
                skuOptions.add(skuOption);
            }
        }
        return skuOptions.toArray(new SkuOption[0]);
    }
}

