/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductSpecification;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=CPDefinitionSpecificationOptionValue"}, service={DTOConverter.class, ProductSpecificationDTOConverter.class})
public class ProductSpecificationDTOConverter
implements DTOConverter<CPDefinitionSpecificationOptionValue, ProductSpecification> {
    @Reference
    private CPDefinitionSpecificationOptionValueLocalService _cpDefinitionSpecificationOptionValueLocalService;
    @Reference
    private Language _language;

    public String getContentType() {
        return ProductSpecification.class.getSimpleName();
    }

    public ProductSpecification toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValue(((Long)dtoConverterContext.getId()).longValue());
        final String languageId = this._language.getLanguageId(dtoConverterContext.getLocale());
        final CPDefinition cpDefinition = cpDefinitionSpecificationOptionValue.getCPDefinition();
        final CPSpecificationOption cpSpecificationOption = cpDefinitionSpecificationOptionValue.getCPSpecificationOption();
        return new ProductSpecification(){
            {
                this.id = cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId();
                this.optionCategoryId = cpDefinitionSpecificationOptionValue.getCPOptionCategoryId();
                this.priority = cpDefinitionSpecificationOptionValue.getPriority();
                this.productId = cpDefinition.getCProductId();
                this.specificationId = cpSpecificationOption.getCPSpecificationOptionId();
                this.specificationKey = cpSpecificationOption.getKey();
                this.value = cpDefinitionSpecificationOptionValue.getValue(languageId);
            }
        };
    }
}

