/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductOptionValue;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=CPDefinitionOptionRel"}, service={DTOConverter.class, ProductOptionDTOConverter.class})
public class ProductOptionDTOConverter
implements DTOConverter<CPDefinitionOptionRel, ProductOption> {
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private Language _language;

    public String getContentType() {
        return ProductOption.class.getSimpleName();
    }

    public ProductOption toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(((Long)dtoConverterContext.getId()).longValue());
        final String languageId = this._language.getLanguageId(dtoConverterContext.getLocale());
        final CPOption cpOption = cpDefinitionOptionRel.getCPOption();
        return new ProductOption(){
            {
                this.description = cpOption.getDescription(languageId);
                this.fieldType = cpDefinitionOptionRel.getDDMFormFieldTypeName();
                this.id = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                this.key = cpOption.getKey();
                this.name = cpOption.getName(languageId);
                this.optionId = cpOption.getCPOptionId();
                this.productOptionValues = ProductOptionDTOConverter.this._toProductOptionValues(cpDefinitionOptionRel, languageId);
            }
        };
    }

    private ProductOptionValue _toProductOptionValue(final CPDefinitionOptionValueRel cpDefinitionOptionValueRel, final String languageId) {
        return new ProductOptionValue(){
            {
                this.id = cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId();
                this.key = cpDefinitionOptionValueRel.getKey();
                this.name = cpDefinitionOptionValueRel.getName(languageId);
                this.priority = cpDefinitionOptionValueRel.getPriority();
            }
        };
    }

    private ProductOptionValue[] _toProductOptionValues(CPDefinitionOptionRel cpDefinitionOptionRel, String languageId) {
        int total = this._cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRelsCount(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
        List cpDefinitionOptionValueRels = this._cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), 0, total);
        ArrayList<ProductOptionValue> productOptionValues = new ArrayList<ProductOptionValue>();
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            productOptionValues.add(this._toProductOptionValue(cpDefinitionOptionValueRel, languageId));
        }
        return productOptionValues.toArray(new ProductOptionValue[0]);
    }
}

