/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductDTOConverterContext;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=CPDefinition"}, service={DTOConverter.class, ProductDTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private Language _language;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final ProductDTOConverterContext productDTOConverterContext = (ProductDTOConverterContext)dtoConverterContext;
        final CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(((Long)productDTOConverterContext.getId()).longValue());
        final String languageId = this._language.getLanguageId(productDTOConverterContext.getLocale());
        final ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
        Product product = new Product(){
            {
                this.createDate = cpDefinition.getCreateDate();
                this.description = cpDefinition.getDescription(languageId);
                this.expando = expandoBridge.getAttributes();
                this.id = cpDefinition.getCPDefinitionId();
                this.metaDescription = cpDefinition.getMetaDescription(languageId);
                this.metaKeyword = cpDefinition.getMetaKeywords(languageId);
                this.metaTitle = cpDefinition.getMetaTitle(languageId);
                this.modifiedDate = cpDefinition.getModifiedDate();
                this.name = cpDefinition.getName(languageId);
                this.productId = cpDefinition.getCProductId();
                this.productType = cpDefinition.getProductTypeName();
                this.shortDescription = cpDefinition.getShortDescription(languageId);
                this.slug = cpDefinition.getURL(languageId);
                this.tags = ProductDTOConverter.this._getTags(cpDefinition);
                this.urls = LanguageUtils.getLanguageIdMap((Map)ProductDTOConverter.this._cpDefinitionLocalService.getUrlTitleMap(cpDefinition.getCPDefinitionId()));
                this.setUrlImage(() -> {
                    Company company = ProductDTOConverter.this._companyLocalService.getCompany(cpDefinition.getCompanyId());
                    String defaultImageFileURL = ProductDTOConverter.this._cpDefinitionHelper.getDefaultImageFileURL(CommerceUtil.getCommerceAccountId((CommerceContext)productDTOConverterContext.getCommerceContext()), cpDefinition.getCPDefinitionId());
                    return company.getPortalURL(0L) + defaultImageFileURL;
                });
            }
        };
        final CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(((Long)productDTOConverterContext.getId()).longValue());
        if (cpDefinitionInventory != null) {
            ProductConfiguration productConfiguration = new ProductConfiguration(){
                {
                    this.allowBackOrder = cpDefinitionInventory.isBackOrders();
                    this.allowedOrderQuantities = ArrayUtil.toArray((int[])cpDefinitionInventory.getAllowedOrderQuantitiesArray());
                    this.inventoryEngine = cpDefinitionInventory.getCPDefinitionInventoryEngine();
                    this.maxOrderQuantity = cpDefinitionInventory.getMaxOrderQuantity();
                    this.minOrderQuantity = cpDefinitionInventory.getMinOrderQuantity();
                    this.multipleOrderQuantity = cpDefinitionInventory.getMultipleOrderQuantity();
                }
            };
            product.setProductConfiguration(productConfiguration);
        }
        return product;
    }

    private String[] _getTags(CPDefinition cpDefinition) {
        List assetEntryAssetTags = this._assetTagLocalService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        Stream stream = assetEntryAssetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }
}

