/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryLocalService;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Availability;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Price;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.MappedProductDTOConverterContext;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductConfigurationDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.ProductOptionDTOConverter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry"}, service={DTOConverter.class, MappedProductDTOConverter.class})
public class MappedProductDTOConverter
implements DTOConverter<CSDiagramEntry, MappedProduct> {
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPDefinitionInventoryEngine _cpDefinitionInventoryEngine;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private CSDiagramEntryLocalService _csDiagramEntryLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JsonHelper _jsonHelper;
    @Reference
    private Language _language;
    @Reference
    private ProductConfigurationDTOConverter _productConfigurationDTOConverter;
    @Reference
    private ProductOptionDTOConverter _productOptionDTOConverter;

    public String getContentType() {
        return MappedProduct.class.getSimpleName();
    }

    public MappedProduct toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        CPDefinition cpDefinition;
        final MappedProductDTOConverterContext mappedProductDTOConverterContext = (MappedProductDTOConverterContext)dtoConverterContext;
        final CommerceContext commerceContext = mappedProductDTOConverterContext.getCommerceContext();
        final CSDiagramEntry csDiagramEntry = this._csDiagramEntryLocalService.getCSDiagramEntry(((Long)mappedProductDTOConverterContext.getId()).longValue());
        long cpInstanceId = GetterUtil.getLong((Object)mappedProductDTOConverterContext.getReplacementCPInstanceId(), (long)csDiagramEntry.getCPInstanceId());
        final CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        long cProductId = GetterUtil.getLong((Object)mappedProductDTOConverterContext.getReplacementCProductId(), (long)csDiagramEntry.getCProductId());
        if (cpInstance != null) {
            CProduct cProduct = this._cProductLocalService.getCProductByCPInstanceUuid(cpInstance.getCPInstanceUuid());
            cProductId = cProduct.getCProductId();
        }
        if ((cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(cProductId)) != null && !this._commerceProductViewPermission.contains(PermissionThreadLocal.getPermissionChecker(), CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), cpDefinition.getCPDefinitionId())) {
            return null;
        }
        final CPInstance firstAvailableReplacementCPInstance = this._cpInstanceHelper.fetchFirstAvailableReplacementCPInstance(commerceContext.getCommerceChannelGroupId(), cpInstanceId);
        return new MappedProduct(){
            {
                this.actions = mappedProductDTOConverterContext.getActions();
                this.id = csDiagramEntry.getCSDiagramEntryId();
                this.price = MappedProductDTOConverter.this._getPrice(commerceContext, cpInstance, mappedProductDTOConverterContext.getLocale(), 1);
                this.quantity = csDiagramEntry.getQuantity();
                this.sequence = csDiagramEntry.getSequence();
                this.sku = csDiagramEntry.getSku();
                this.skuOptions = MappedProductDTOConverter.this._getSkuOptions(cpInstance);
                this.setAvailability(() -> {
                    if (cpInstance == null) {
                        return null;
                    }
                    return MappedProductDTOConverter.this._getAvailability(commerceContext.getCommerceChannelGroupId(), mappedProductDTOConverterContext.getCompanyId(), cpInstance, mappedProductDTOConverterContext.getLocale(), cpInstance.getSku());
                });
                this.setFirstAvailableReplacementMappedProduct(() -> {
                    MappedProduct firstAvailableReplacementMappedProduct = null;
                    if (cpInstance != null && cpInstance.isDiscontinued() && firstAvailableReplacementCPInstance != null) {
                        mappedProductDTOConverterContext.setReplacementCPInstanceId(firstAvailableReplacementCPInstance.getCPInstanceId());
                        CPDefinition firstAvailableReplacementCPDefinition = firstAvailableReplacementCPInstance.getCPDefinition();
                        mappedProductDTOConverterContext.setReplacementCProductId(firstAvailableReplacementCPDefinition.getCProductId());
                        firstAvailableReplacementMappedProduct = MappedProductDTOConverter.this.toDTO((DTOConverterContext)mappedProductDTOConverterContext);
                    }
                    mappedProductDTOConverterContext.setReplacementCPInstanceId(null);
                    mappedProductDTOConverterContext.setReplacementCProductId(null);
                    return firstAvailableReplacementMappedProduct;
                });
                this.setProductConfiguration(() -> {
                    if (cpDefinition == null) {
                        return null;
                    }
                    return MappedProductDTOConverter.this._productConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(MappedProductDTOConverter.this._dtoConverterRegistry, (Object)cpDefinition.getCPDefinitionId(), mappedProductDTOConverterContext.getLocale(), null, null));
                });
                this.setProductExternalReferenceCode(() -> {
                    if (cpDefinition == null) {
                        return "";
                    }
                    CProduct cProduct = cpDefinition.getCProduct();
                    return cProduct.getExternalReferenceCode();
                });
                this.setProductId(() -> {
                    if (cpDefinition == null) {
                        return null;
                    }
                    return cpDefinition.getCProductId();
                });
                this.setProductName(() -> {
                    if (cpDefinition == null) {
                        return null;
                    }
                    return LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                });
                this.setProductOptions(() -> {
                    if (cpDefinition == null) {
                        return null;
                    }
                    ArrayList<ProductOption> productOptions = new ArrayList<ProductOption>();
                    for (CPDefinitionOptionRel cpDefinitionOptionRel : MappedProductDTOConverter.this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinition.getCPDefinitionId())) {
                        productOptions.add(MappedProductDTOConverter.this._productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionOptionRel.getCPDefinitionOptionRelId(), mappedProductDTOConverterContext.getLocale())));
                    }
                    return productOptions.toArray(new ProductOption[0]);
                });
                this.setPurchasable(() -> {
                    if (cpInstance == null) {
                        return null;
                    }
                    return cpInstance.isPurchasable();
                });
                this.setReplacementMappedProduct(() -> {
                    MappedProduct replacementMappedProduct = null;
                    if (cpInstance != null && cpInstance.isDiscontinued()) {
                        CPInstance replacementCPInstance = MappedProductDTOConverter.this._cpInstanceHelper.fetchReplacementCPInstance(cpInstance.getReplacementCProductId(), cpInstance.getReplacementCPInstanceUuid());
                        if (replacementCPInstance == null) {
                            return null;
                        }
                        mappedProductDTOConverterContext.setReplacementCPInstanceId(replacementCPInstance.getCPInstanceId());
                        mappedProductDTOConverterContext.setReplacementCProductId(cpInstance.getReplacementCProductId());
                        replacementMappedProduct = MappedProductDTOConverter.this.toDTO((DTOConverterContext)mappedProductDTOConverterContext);
                    }
                    mappedProductDTOConverterContext.setReplacementCPInstanceId(null);
                    mappedProductDTOConverterContext.setReplacementCProductId(null);
                    return replacementMappedProduct;
                });
                this.setReplacementMessage(() -> {
                    if (cpInstance != null && cpInstance.isDiscontinued() && firstAvailableReplacementCPInstance != null && cpInstance.getCPInstanceId() == csDiagramEntry.getCPInstanceId()) {
                        return MappedProductDTOConverter.this._language.format(mappedProductDTOConverterContext.getLocale(), "x-has-been-replaced-by-x", (Object[])new String[]{csDiagramEntry.getSku(), firstAvailableReplacementCPInstance.getSku()});
                    }
                    return null;
                });
                this.setSkuExternalReferenceCode(() -> {
                    if (cpInstance == null) {
                        return "";
                    }
                    return cpInstance.getExternalReferenceCode();
                });
                this.setSkuId(() -> {
                    if (cpInstance == null) {
                        return null;
                    }
                    return cpInstance.getCPInstanceId();
                });
                this.setThumbnail(() -> {
                    if (cpDefinition == null) {
                        return "";
                    }
                    return cpDefinition.getDefaultImageThumbnailSrc(CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext));
                });
                this.setType(() -> {
                    if (csDiagramEntry.isDiagram()) {
                        return MappedProduct.Type.create((String)MappedProduct.Type.DIAGRAM.getValue());
                    }
                    if (csDiagramEntry.getCPInstanceId() > 0L) {
                        return MappedProduct.Type.create((String)MappedProduct.Type.SKU.getValue());
                    }
                    return MappedProduct.Type.create((String)MappedProduct.Type.EXTERNAL.getValue());
                });
                this.setUrls(() -> {
                    if (cpDefinition == null) {
                        return null;
                    }
                    return LanguageUtils.getLanguageIdMap((Map)MappedProductDTOConverter.this._cpDefinitionLocalService.getUrlTitleMap(cpDefinition.getCPDefinitionId()));
                });
            }
        };
    }

    private Availability _getAvailability(long commerceChannelGroupId, long companyId, CPInstance cpInstance, Locale locale, String sku) throws Exception {
        Availability availability = new Availability();
        if (this._cpDefinitionInventoryEngine.isDisplayAvailability(cpInstance)) {
            if (Objects.equals(this._commerceInventoryEngine.getAvailabilityStatus(cpInstance.getCompanyId(), commerceChannelGroupId, this._cpDefinitionInventoryEngine.getMinStockQuantity(cpInstance), cpInstance.getSku()), "available")) {
                availability.setLabel_i18n(this._language.get(locale, "available"));
                availability.setLabel("available");
            } else {
                availability.setLabel_i18n(this._language.get(locale, "unavailable"));
                availability.setLabel("unavailable");
            }
        }
        if (this._cpDefinitionInventoryEngine.isDisplayStockQuantity(cpInstance)) {
            availability.setStockQuantity(Integer.valueOf(this._commerceInventoryEngine.getStockQuantity(companyId, commerceChannelGroupId, sku)));
        }
        return availability;
    }

    private String[] _getFormattedDiscountPercentages(BigDecimal[] discountPercentages, Locale locale) throws Exception {
        ArrayList<String> formattedDiscountPercentages = new ArrayList<String>();
        for (BigDecimal percentage : discountPercentages) {
            formattedDiscountPercentages.add(this._commercePriceFormatter.format(percentage, locale));
        }
        return formattedDiscountPercentages.toArray(new String[0]);
    }

    private Price _getPrice(CommerceContext commerceContext, CPInstance cpInstance, final Locale locale, int quantity) throws Exception {
        CommerceDiscountValue discountValue;
        if (cpInstance == null) {
            return null;
        }
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(cpInstance.getCPInstanceId(), quantity, true, commerceContext);
        if (commerceProductPrice == null) {
            return new Price();
        }
        final CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        final CommerceMoney unitPriceCommerceMoney = commerceProductPrice.getUnitPrice();
        Price price = new Price(){
            {
                this.currency = commerceCurrency.getName(locale);
                this.priceFormatted = unitPriceCommerceMoney.format(locale);
                this.setPrice(() -> {
                    BigDecimal unitPrice = unitPriceCommerceMoney.getPrice();
                    return unitPrice.doubleValue();
                });
            }
        };
        CommerceMoney unitPromoPriceCommerceMoney = commerceProductPrice.getUnitPromoPrice();
        BigDecimal unitPromoPrice = unitPromoPriceCommerceMoney.getPrice();
        if (unitPromoPrice != null && unitPromoPrice.compareTo(BigDecimal.ZERO) > 0 && unitPromoPrice.compareTo(unitPriceCommerceMoney.getPrice()) < 0) {
            price.setPromoPrice(Double.valueOf(unitPromoPrice.doubleValue()));
            price.setPromoPriceFormatted(unitPromoPriceCommerceMoney.format(locale));
        }
        if ((discountValue = commerceProductPrice.getDiscountValue()) != null) {
            CommerceMoney discountAmountCommerceMoney = discountValue.getDiscountAmount();
            price.setDiscount(discountAmountCommerceMoney.format(locale));
            price.setDiscountPercentage(this._commercePriceFormatter.format(discountValue.getDiscountPercentage(), locale));
            price.setDiscountPercentages(this._getFormattedDiscountPercentages(discountValue.getPercentages(), locale));
            CommerceMoney finalPriceCommerceMoney = commerceProductPrice.getFinalPrice();
            price.setFinalPrice(finalPriceCommerceMoney.format(locale));
        }
        return price;
    }

    private SkuOption[] _getSkuOptions(CPInstance cpInstance) throws Exception {
        if (cpInstance == null) {
            return null;
        }
        ArrayList<3> skuOptions = new ArrayList<3>();
        JSONArray keyValuesJSONArray = this._jsonHelper.toJSONArray(this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstance.getCPInstanceId()));
        Map cpDefinitionOptionValueRelsMap = this._cpInstanceHelper.getCPDefinitionOptionValueRelsMap(cpInstance.getCPDefinitionId(), keyValuesJSONArray.toString());
        for (Map.Entry entry : cpDefinitionOptionValueRelsMap.entrySet()) {
            final CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)entry.getKey();
            List cpDefinitionOptionValueRels = (List)entry.getValue();
            for (final CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                SkuOption skuOption = new SkuOption(){
                    {
                        this.key = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                        this.value = cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId();
                    }
                };
                skuOptions.add(skuOption);
            }
        }
        return skuOptions.toArray(new SkuOption[0]);
    }
}

