/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;

import java.util.HashMap;
import java.util.Locale;

/**
 * @author Andrea Sbarra
 */
public class ProductDTOConverterContext extends DefaultDTOConverterContext {

	public ProductDTOConverterContext(
		CommerceContext commerceContext, CPCatalogEntry cpCatalogEntry,
		Object id, Locale locale) {

		super(false, new HashMap<>(), null, id, locale, null, null);

		_commerceContext = commerceContext;
		_cpCatalogEntry = cpCatalogEntry;
	}

	public ProductDTOConverterContext(
		CommerceContext commerceContext, CPDefinition cpDefinition, Object id,
		Locale locale) {

		super(false, new HashMap<>(), null, id, locale, null, null);

		_commerceContext = commerceContext;
		_cpDefinition = cpDefinition;
	}

	public CommerceContext getCommerceContext() {
		return _commerceContext;
	}

	public CPCatalogEntry getCPCatalogEntry() {
		return _cpCatalogEntry;
	}

	public CPDefinition getCPDefinition() {
		return _cpDefinition;
	}

	private final CommerceContext _commerceContext;
	private CPCatalogEntry _cpCatalogEntry;
	private CPDefinition _cpDefinition;

}