/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ProductConfiguration")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="ProductConfiguration")
public class ProductConfiguration
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean allowBackOrder;
    @JsonIgnore
    private Supplier<Boolean> _allowBackOrderSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal[] allowedOrderQuantities;
    @JsonIgnore
    private Supplier<BigDecimal[]> _allowedOrderQuantitiesSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long availabilityEstimateId;
    @JsonIgnore
    private Supplier<Long> _availabilityEstimateIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String availabilityEstimateName;
    @JsonIgnore
    private Supplier<String> _availabilityEstimateNameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean displayAvailability;
    @JsonIgnore
    private Supplier<Boolean> _displayAvailabilitySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean displayStockQuantity;
    @JsonIgnore
    private Supplier<Boolean> _displayStockQuantitySupplier;
    @GraphQLField(description="The inventory engine that will be used to manage the product inventory")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The inventory engine that will be used to manage the product inventory") String inventoryEngine;
    @JsonIgnore
    private Supplier<String> _inventoryEngineSupplier;
    @GraphQLField(description="The low stock action that will be performed when a product is out of stock")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The low stock action that will be performed when a product is out of stock") String lowStockAction;
    @JsonIgnore
    private Supplier<String> _lowStockActionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal maxOrderQuantity;
    @JsonIgnore
    private Supplier<BigDecimal> _maxOrderQuantitySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal minOrderQuantity;
    @JsonIgnore
    private Supplier<BigDecimal> _minOrderQuantitySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal minStockQuantity;
    @JsonIgnore
    private Supplier<BigDecimal> _minStockQuantitySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal multipleOrderQuantity;
    @JsonIgnore
    private Supplier<BigDecimal> _multipleOrderQuantitySupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.delivery.catalog.dto.v1_0.ProductConfiguration", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static ProductConfiguration toDTO(String json) {
        return (ProductConfiguration)ObjectMapperUtil.readValue(ProductConfiguration.class, (String)json);
    }

    public static ProductConfiguration unsafeToDTO(String json) {
        return (ProductConfiguration)ObjectMapperUtil.unsafeReadValue(ProductConfiguration.class, (String)json);
    }

    @Schema(example="true")
    public Boolean getAllowBackOrder() {
        if (this._allowBackOrderSupplier != null) {
            this.allowBackOrder = this._allowBackOrderSupplier.get();
            this._allowBackOrderSupplier = null;
        }
        return this.allowBackOrder;
    }

    public void setAllowBackOrder(Boolean allowBackOrder) {
        this.allowBackOrder = allowBackOrder;
        this._allowBackOrderSupplier = null;
    }

    @JsonIgnore
    public void setAllowBackOrder(UnsafeSupplier<Boolean, Exception> allowBackOrderUnsafeSupplier) {
        this._allowBackOrderSupplier = () -> {
            try {
                return (Boolean)allowBackOrderUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="[10, 20, 30, 40]")
    @Valid
    public BigDecimal[] getAllowedOrderQuantities() {
        if (this._allowedOrderQuantitiesSupplier != null) {
            this.allowedOrderQuantities = this._allowedOrderQuantitiesSupplier.get();
            this._allowedOrderQuantitiesSupplier = null;
        }
        return this.allowedOrderQuantities;
    }

    public void setAllowedOrderQuantities(BigDecimal[] allowedOrderQuantities) {
        this.allowedOrderQuantities = allowedOrderQuantities;
        this._allowedOrderQuantitiesSupplier = null;
    }

    @JsonIgnore
    public void setAllowedOrderQuantities(UnsafeSupplier<BigDecimal[], Exception> allowedOrderQuantitiesUnsafeSupplier) {
        this._allowedOrderQuantitiesSupplier = () -> {
            try {
                return (BigDecimal[])allowedOrderQuantitiesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="31130")
    public @DecimalMin(value="0") Long getAvailabilityEstimateId() {
        if (this._availabilityEstimateIdSupplier != null) {
            this.availabilityEstimateId = this._availabilityEstimateIdSupplier.get();
            this._availabilityEstimateIdSupplier = null;
        }
        return this.availabilityEstimateId;
    }

    public void setAvailabilityEstimateId(Long availabilityEstimateId) {
        this.availabilityEstimateId = availabilityEstimateId;
        this._availabilityEstimateIdSupplier = null;
    }

    @JsonIgnore
    public void setAvailabilityEstimateId(UnsafeSupplier<Long, Exception> availabilityEstimateIdUnsafeSupplier) {
        this._availabilityEstimateIdSupplier = () -> {
            try {
                return (Long)availabilityEstimateIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getAvailabilityEstimateName() {
        if (this._availabilityEstimateNameSupplier != null) {
            this.availabilityEstimateName = this._availabilityEstimateNameSupplier.get();
            this._availabilityEstimateNameSupplier = null;
        }
        return this.availabilityEstimateName;
    }

    public void setAvailabilityEstimateName(String availabilityEstimateName) {
        this.availabilityEstimateName = availabilityEstimateName;
        this._availabilityEstimateNameSupplier = null;
    }

    @JsonIgnore
    public void setAvailabilityEstimateName(UnsafeSupplier<String, Exception> availabilityEstimateNameUnsafeSupplier) {
        this._availabilityEstimateNameSupplier = () -> {
            try {
                return (String)availabilityEstimateNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getDisplayAvailability() {
        if (this._displayAvailabilitySupplier != null) {
            this.displayAvailability = this._displayAvailabilitySupplier.get();
            this._displayAvailabilitySupplier = null;
        }
        return this.displayAvailability;
    }

    public void setDisplayAvailability(Boolean displayAvailability) {
        this.displayAvailability = displayAvailability;
        this._displayAvailabilitySupplier = null;
    }

    @JsonIgnore
    public void setDisplayAvailability(UnsafeSupplier<Boolean, Exception> displayAvailabilityUnsafeSupplier) {
        this._displayAvailabilitySupplier = () -> {
            try {
                return (Boolean)displayAvailabilityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getDisplayStockQuantity() {
        if (this._displayStockQuantitySupplier != null) {
            this.displayStockQuantity = this._displayStockQuantitySupplier.get();
            this._displayStockQuantitySupplier = null;
        }
        return this.displayStockQuantity;
    }

    public void setDisplayStockQuantity(Boolean displayStockQuantity) {
        this.displayStockQuantity = displayStockQuantity;
        this._displayStockQuantitySupplier = null;
    }

    @JsonIgnore
    public void setDisplayStockQuantity(UnsafeSupplier<Boolean, Exception> displayStockQuantityUnsafeSupplier) {
        this._displayStockQuantitySupplier = () -> {
            try {
                return (Boolean)displayStockQuantityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The inventory engine that will be used to manage the product inventory")
    public String getInventoryEngine() {
        if (this._inventoryEngineSupplier != null) {
            this.inventoryEngine = this._inventoryEngineSupplier.get();
            this._inventoryEngineSupplier = null;
        }
        return this.inventoryEngine;
    }

    public void setInventoryEngine(String inventoryEngine) {
        this.inventoryEngine = inventoryEngine;
        this._inventoryEngineSupplier = null;
    }

    @JsonIgnore
    public void setInventoryEngine(UnsafeSupplier<String, Exception> inventoryEngineUnsafeSupplier) {
        this._inventoryEngineSupplier = () -> {
            try {
                return (String)inventoryEngineUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The low stock action that will be performed when a product is out of stock")
    public String getLowStockAction() {
        if (this._lowStockActionSupplier != null) {
            this.lowStockAction = this._lowStockActionSupplier.get();
            this._lowStockActionSupplier = null;
        }
        return this.lowStockAction;
    }

    public void setLowStockAction(String lowStockAction) {
        this.lowStockAction = lowStockAction;
        this._lowStockActionSupplier = null;
    }

    @JsonIgnore
    public void setLowStockAction(UnsafeSupplier<String, Exception> lowStockActionUnsafeSupplier) {
        this._lowStockActionSupplier = () -> {
            try {
                return (String)lowStockActionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="10.1")
    @Valid
    public BigDecimal getMaxOrderQuantity() {
        if (this._maxOrderQuantitySupplier != null) {
            this.maxOrderQuantity = this._maxOrderQuantitySupplier.get();
            this._maxOrderQuantitySupplier = null;
        }
        return this.maxOrderQuantity;
    }

    public void setMaxOrderQuantity(BigDecimal maxOrderQuantity) {
        this.maxOrderQuantity = maxOrderQuantity;
        this._maxOrderQuantitySupplier = null;
    }

    @JsonIgnore
    public void setMaxOrderQuantity(UnsafeSupplier<BigDecimal, Exception> maxOrderQuantityUnsafeSupplier) {
        this._maxOrderQuantitySupplier = () -> {
            try {
                return (BigDecimal)maxOrderQuantityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="10.1")
    @Valid
    public BigDecimal getMinOrderQuantity() {
        if (this._minOrderQuantitySupplier != null) {
            this.minOrderQuantity = this._minOrderQuantitySupplier.get();
            this._minOrderQuantitySupplier = null;
        }
        return this.minOrderQuantity;
    }

    public void setMinOrderQuantity(BigDecimal minOrderQuantity) {
        this.minOrderQuantity = minOrderQuantity;
        this._minOrderQuantitySupplier = null;
    }

    @JsonIgnore
    public void setMinOrderQuantity(UnsafeSupplier<BigDecimal, Exception> minOrderQuantityUnsafeSupplier) {
        this._minOrderQuantitySupplier = () -> {
            try {
                return (BigDecimal)minOrderQuantityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="10.1")
    @Valid
    public BigDecimal getMinStockQuantity() {
        if (this._minStockQuantitySupplier != null) {
            this.minStockQuantity = this._minStockQuantitySupplier.get();
            this._minStockQuantitySupplier = null;
        }
        return this.minStockQuantity;
    }

    public void setMinStockQuantity(BigDecimal minStockQuantity) {
        this.minStockQuantity = minStockQuantity;
        this._minStockQuantitySupplier = null;
    }

    @JsonIgnore
    public void setMinStockQuantity(UnsafeSupplier<BigDecimal, Exception> minStockQuantityUnsafeSupplier) {
        this._minStockQuantitySupplier = () -> {
            try {
                return (BigDecimal)minStockQuantityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="10.1")
    @Valid
    public BigDecimal getMultipleOrderQuantity() {
        if (this._multipleOrderQuantitySupplier != null) {
            this.multipleOrderQuantity = this._multipleOrderQuantitySupplier.get();
            this._multipleOrderQuantitySupplier = null;
        }
        return this.multipleOrderQuantity;
    }

    public void setMultipleOrderQuantity(BigDecimal multipleOrderQuantity) {
        this.multipleOrderQuantity = multipleOrderQuantity;
        this._multipleOrderQuantitySupplier = null;
    }

    @JsonIgnore
    public void setMultipleOrderQuantity(UnsafeSupplier<BigDecimal, Exception> multipleOrderQuantityUnsafeSupplier) {
        this._multipleOrderQuantitySupplier = () -> {
            try {
                return (BigDecimal)multipleOrderQuantityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductConfiguration)) {
            return false;
        }
        ProductConfiguration productConfiguration = (ProductConfiguration)object;
        return Objects.equals(this.toString(), productConfiguration.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        BigDecimal multipleOrderQuantity;
        BigDecimal minStockQuantity;
        BigDecimal minOrderQuantity;
        BigDecimal maxOrderQuantity;
        String lowStockAction;
        String inventoryEngine;
        Boolean displayStockQuantity;
        Boolean displayAvailability;
        String availabilityEstimateName;
        Long availabilityEstimateId;
        BigDecimal[] allowedOrderQuantities;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Boolean allowBackOrder = this.getAllowBackOrder();
        if (allowBackOrder != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"allowBackOrder\": ");
            sb.append((Object)allowBackOrder);
        }
        if ((allowedOrderQuantities = this.getAllowedOrderQuantities()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"allowedOrderQuantities\": ");
            sb.append("[");
            for (int i = 0; i < allowedOrderQuantities.length; ++i) {
                sb.append((Object)allowedOrderQuantities[i]);
                if (i + 1 >= allowedOrderQuantities.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((availabilityEstimateId = this.getAvailabilityEstimateId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availabilityEstimateId\": ");
            sb.append((Object)availabilityEstimateId);
        }
        if ((availabilityEstimateName = this.getAvailabilityEstimateName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"availabilityEstimateName\": ");
            sb.append("\"");
            sb.append(ProductConfiguration._escape(availabilityEstimateName));
            sb.append("\"");
        }
        if ((displayAvailability = this.getDisplayAvailability()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayAvailability\": ");
            sb.append((Object)displayAvailability);
        }
        if ((displayStockQuantity = this.getDisplayStockQuantity()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayStockQuantity\": ");
            sb.append((Object)displayStockQuantity);
        }
        if ((inventoryEngine = this.getInventoryEngine()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"inventoryEngine\": ");
            sb.append("\"");
            sb.append(ProductConfiguration._escape(inventoryEngine));
            sb.append("\"");
        }
        if ((lowStockAction = this.getLowStockAction()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"lowStockAction\": ");
            sb.append("\"");
            sb.append(ProductConfiguration._escape(lowStockAction));
            sb.append("\"");
        }
        if ((maxOrderQuantity = this.getMaxOrderQuantity()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"maxOrderQuantity\": ");
            sb.append((Object)maxOrderQuantity);
        }
        if ((minOrderQuantity = this.getMinOrderQuantity()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"minOrderQuantity\": ");
            sb.append((Object)minOrderQuantity);
        }
        if ((minStockQuantity = this.getMinStockQuantity()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"minStockQuantity\": ");
            sb.append((Object)minStockQuantity);
        }
        if ((multipleOrderQuantity = this.getMultipleOrderQuantity()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"multipleOrderQuantity\": ");
            sb.append((Object)multipleOrderQuantity);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ProductConfiguration._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ProductConfiguration._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(ProductConfiguration._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ProductConfiguration._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ProductConfiguration._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

