/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.CustomField;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Account")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"name"})
@XmlRootElement(name="Account")
public class Account
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected CustomField[] customFields;
    @JsonIgnore
    private Supplier<CustomField[]> _customFieldsSupplier;
    @GraphQLField(description="The account's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The account's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The account's most recent modification date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The account's most recent modification date.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long defaultBillingAddressId;
    @JsonIgnore
    private Supplier<Long> _defaultBillingAddressIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long defaultShippingAddressId;
    @JsonIgnore
    private Supplier<Long> _defaultShippingAddressIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String description;
    @JsonIgnore
    private Supplier<String> _descriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] domains;
    @JsonIgnore
    private Supplier<String[]> _domainsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long logoId;
    @JsonIgnore
    private Supplier<Long> _logoIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String logoURL;
    @JsonIgnore
    private Supplier<String> _logoURLSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long[] organizationIds;
    @JsonIgnore
    private Supplier<Long[]> _organizationIdsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer status;
    @JsonIgnore
    private Supplier<Integer> _statusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String taxId;
    @JsonIgnore
    private Supplier<String> _taxIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Type type;
    @JsonIgnore
    private Supplier<Type> _typeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Account", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Account toDTO(String json) {
        return (Account)ObjectMapperUtil.readValue(Account.class, (String)json);
    }

    public static Account unsafeToDTO(String json) {
        return (Account)ObjectMapperUtil.unsafeReadValue(Account.class, (String)json);
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public CustomField[] getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (CustomField[])customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The account's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The account's most recent modification date.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="10130")
    public @DecimalMin(value="0") Long getDefaultBillingAddressId() {
        if (this._defaultBillingAddressIdSupplier != null) {
            this.defaultBillingAddressId = this._defaultBillingAddressIdSupplier.get();
            this._defaultBillingAddressIdSupplier = null;
        }
        return this.defaultBillingAddressId;
    }

    public void setDefaultBillingAddressId(Long defaultBillingAddressId) {
        this.defaultBillingAddressId = defaultBillingAddressId;
        this._defaultBillingAddressIdSupplier = null;
    }

    @JsonIgnore
    public void setDefaultBillingAddressId(UnsafeSupplier<Long, Exception> defaultBillingAddressIdUnsafeSupplier) {
        this._defaultBillingAddressIdSupplier = () -> {
            try {
                return (Long)defaultBillingAddressIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="10131")
    public @DecimalMin(value="0") Long getDefaultShippingAddressId() {
        if (this._defaultShippingAddressIdSupplier != null) {
            this.defaultShippingAddressId = this._defaultShippingAddressIdSupplier.get();
            this._defaultShippingAddressIdSupplier = null;
        }
        return this.defaultShippingAddressId;
    }

    public void setDefaultShippingAddressId(Long defaultShippingAddressId) {
        this.defaultShippingAddressId = defaultShippingAddressId;
        this._defaultShippingAddressIdSupplier = null;
    }

    @JsonIgnore
    public void setDefaultShippingAddressId(UnsafeSupplier<Long, Exception> defaultShippingAddressIdUnsafeSupplier) {
        this._defaultShippingAddressIdSupplier = () -> {
            try {
                return (Long)defaultShippingAddressIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (String)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String[] getDomains() {
        if (this._domainsSupplier != null) {
            this.domains = this._domainsSupplier.get();
            this._domainsSupplier = null;
        }
        return this.domains;
    }

    public void setDomains(String[] domains) {
        this.domains = domains;
        this._domainsSupplier = null;
    }

    @JsonIgnore
    public void setDomains(UnsafeSupplier<String[], Exception> domainsUnsafeSupplier) {
        this._domainsSupplier = () -> {
            try {
                return (String[])domainsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="20078")
    public @DecimalMin(value="0") Long getLogoId() {
        if (this._logoIdSupplier != null) {
            this.logoId = this._logoIdSupplier.get();
            this._logoIdSupplier = null;
        }
        return this.logoId;
    }

    public void setLogoId(Long logoId) {
        this.logoId = logoId;
        this._logoIdSupplier = null;
    }

    @JsonIgnore
    public void setLogoId(UnsafeSupplier<Long, Exception> logoIdUnsafeSupplier) {
        this._logoIdSupplier = () -> {
            try {
                return (Long)logoIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getLogoURL() {
        if (this._logoURLSupplier != null) {
            this.logoURL = this._logoURLSupplier.get();
            this._logoURLSupplier = null;
        }
        return this.logoURL;
    }

    public void setLogoURL(String logoURL) {
        this.logoURL = logoURL;
        this._logoURLSupplier = null;
    }

    @JsonIgnore
    public void setLogoURL(UnsafeSupplier<String, Exception> logoURLUnsafeSupplier) {
        this._logoURLSupplier = () -> {
            try {
                return (String)logoURLUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Account Name")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Long[] getOrganizationIds() {
        if (this._organizationIdsSupplier != null) {
            this.organizationIds = this._organizationIdsSupplier.get();
            this._organizationIdsSupplier = null;
        }
        return this.organizationIds;
    }

    public void setOrganizationIds(Long[] organizationIds) {
        this.organizationIds = organizationIds;
        this._organizationIdsSupplier = null;
    }

    @JsonIgnore
    public void setOrganizationIds(UnsafeSupplier<Long[], Exception> organizationIdsUnsafeSupplier) {
        this._organizationIdsSupplier = () -> {
            try {
                return (Long[])organizationIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Integer getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Integer, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (Integer)statusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Abcd1234")
    public String getTaxId() {
        if (this._taxIdSupplier != null) {
            this.taxId = this._taxIdSupplier.get();
            this._taxIdSupplier = null;
        }
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
        this._taxIdSupplier = null;
    }

    @JsonIgnore
    public void setTaxId(UnsafeSupplier<String, Exception> taxIdUnsafeSupplier) {
        this._taxIdSupplier = () -> {
            try {
                return (String)taxIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @JsonGetter(value="type")
    @Schema
    @Valid
    public Type getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    @JsonIgnore
    public String getTypeAsString() {
        Type type = this.getType();
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    public void setType(Type type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Type, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (Type)((Object)((Object)typeUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Account)) {
            return false;
        }
        Account account = (Account)object;
        return Objects.equals(this.toString(), account.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Type type;
        String taxId;
        Integer status;
        Long[] organizationIds;
        String name;
        String logoURL;
        Long logoId;
        Long id;
        String externalReferenceCode;
        String[] domains;
        String description;
        Long defaultShippingAddressId;
        Long defaultBillingAddressId;
        Date dateModified;
        Date dateCreated;
        CustomField[] customFields;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Account._toJSON(actions));
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < customFields.length; ++i) {
                sb.append(String.valueOf(customFields[i]));
                if (i + 1 >= customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((defaultBillingAddressId = this.getDefaultBillingAddressId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultBillingAddressId\": ");
            sb.append((Object)defaultBillingAddressId);
        }
        if ((defaultShippingAddressId = this.getDefaultShippingAddressId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"defaultShippingAddressId\": ");
            sb.append((Object)defaultShippingAddressId);
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(Account._escape(description));
            sb.append("\"");
        }
        if ((domains = this.getDomains()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"domains\": ");
            sb.append("[");
            for (int i = 0; i < domains.length; ++i) {
                sb.append("\"");
                sb.append(Account._escape(domains[i]));
                sb.append("\"");
                if (i + 1 >= domains.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Account._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((logoId = this.getLogoId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoId\": ");
            sb.append((Object)logoId);
        }
        if ((logoURL = this.getLogoURL()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logoURL\": ");
            sb.append("\"");
            sb.append(Account._escape(logoURL));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Account._escape(name));
            sb.append("\"");
        }
        if ((organizationIds = this.getOrganizationIds()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"organizationIds\": ");
            sb.append("[");
            for (int i = 0; i < organizationIds.length; ++i) {
                sb.append((Object)organizationIds[i]);
                if (i + 1 >= organizationIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append((Object)status);
        }
        if ((taxId = this.getTaxId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"taxId\": ");
            sb.append("\"");
            sb.append(Account._escape(taxId));
            sb.append("\"");
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append((Object)type);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Account._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Account._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Account._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Account._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Account._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="Type")
    public static enum Type {
        BUSINESS("business"),
        GUEST("guest"),
        PERSON("person"),
        SUPPLIER("supplier");

        private final String _value;

        @JsonCreator
        public static Type create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!Objects.equals(type.getValue(), value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Type(String value) {
            this._value = value;
        }
    }
}

