/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.site.setting.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Warehouse")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"commerceCountryId", "name"})
@XmlRootElement(name="Warehouse")
public class Warehouse
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean active;
    @JsonIgnore
    private Supplier<Boolean> _activeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String city;
    @JsonIgnore
    private Supplier<String> _citySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long commerceCountryId;
    @JsonIgnore
    private Supplier<Long> _commerceCountryIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long commerceRegionId;
    @JsonIgnore
    private Supplier<Long> _commerceRegionIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> description;
    @JsonIgnore
    private Supplier<Map<String, String>> _descriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long groupId;
    @JsonIgnore
    private Supplier<Long> _groupIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Double latitude;
    @JsonIgnore
    private Supplier<Double> _latitudeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Double longitude;
    @JsonIgnore
    private Supplier<Double> _longitudeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Number mvccVersion;
    @JsonIgnore
    private Supplier<Number> _mvccVersionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Map<String, String> name;
    @JsonIgnore
    private Supplier<Map<String, String>> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean primary;
    @JsonIgnore
    private Supplier<Boolean> _primarySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String street1;
    @JsonIgnore
    private Supplier<String> _street1Supplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String street2;
    @JsonIgnore
    private Supplier<String> _street2Supplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String street3;
    @JsonIgnore
    private Supplier<String> _street3Supplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String zip;
    @JsonIgnore
    private Supplier<String> _zipSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.site.setting.dto.v1_0.Warehouse", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Warehouse toDTO(String json) {
        return (Warehouse)ObjectMapperUtil.readValue(Warehouse.class, (String)json);
    }

    public static Warehouse unsafeToDTO(String json) {
        return (Warehouse)ObjectMapperUtil.unsafeReadValue(Warehouse.class, (String)json);
    }

    @Schema(example="true")
    public Boolean getActive() {
        if (this._activeSupplier != null) {
            this.active = this._activeSupplier.get();
            this._activeSupplier = null;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
        this._activeSupplier = null;
    }

    @JsonIgnore
    public void setActive(UnsafeSupplier<Boolean, Exception> activeUnsafeSupplier) {
        this._activeSupplier = () -> {
            try {
                return (Boolean)activeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Diamond Bar")
    public String getCity() {
        if (this._citySupplier != null) {
            this.city = this._citySupplier.get();
            this._citySupplier = null;
        }
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
        this._citySupplier = null;
    }

    @JsonIgnore
    public void setCity(UnsafeSupplier<String, Exception> cityUnsafeSupplier) {
        this._citySupplier = () -> {
            try {
                return (String)cityUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getCommerceCountryId() {
        if (this._commerceCountryIdSupplier != null) {
            this.commerceCountryId = this._commerceCountryIdSupplier.get();
            this._commerceCountryIdSupplier = null;
        }
        return this.commerceCountryId;
    }

    public void setCommerceCountryId(Long commerceCountryId) {
        this.commerceCountryId = commerceCountryId;
        this._commerceCountryIdSupplier = null;
    }

    @JsonIgnore
    public void setCommerceCountryId(UnsafeSupplier<Long, Exception> commerceCountryIdUnsafeSupplier) {
        this._commerceCountryIdSupplier = () -> {
            try {
                return (Long)commerceCountryIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30234")
    public @DecimalMin(value="0") Long getCommerceRegionId() {
        if (this._commerceRegionIdSupplier != null) {
            this.commerceRegionId = this._commerceRegionIdSupplier.get();
            this._commerceRegionIdSupplier = null;
        }
        return this.commerceRegionId;
    }

    public void setCommerceRegionId(Long commerceRegionId) {
        this.commerceRegionId = commerceRegionId;
        this._commerceRegionIdSupplier = null;
    }

    @JsonIgnore
    public void setCommerceRegionId(UnsafeSupplier<Long, Exception> commerceRegionIdUnsafeSupplier) {
        this._commerceRegionIdSupplier = () -> {
            try {
                return (Long)commerceRegionIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=Warehouse Description US, hr_HR=Warehouse Description HR, hu_HU=Warehouse Description HU}")
    @Valid
    public Map<String, String> getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(Map<String, String> description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<Map<String, String>, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (Map)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="23130")
    public @DecimalMin(value="0") Long getGroupId() {
        if (this._groupIdSupplier != null) {
            this.groupId = this._groupIdSupplier.get();
            this._groupIdSupplier = null;
        }
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
        this._groupIdSupplier = null;
    }

    @JsonIgnore
    public void setGroupId(UnsafeSupplier<Long, Exception> groupIdUnsafeSupplier) {
        this._groupIdSupplier = () -> {
            try {
                return (Long)groupIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="33.9976884")
    public Double getLatitude() {
        if (this._latitudeSupplier != null) {
            this.latitude = this._latitudeSupplier.get();
            this._latitudeSupplier = null;
        }
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
        this._latitudeSupplier = null;
    }

    @JsonIgnore
    public void setLatitude(UnsafeSupplier<Double, Exception> latitudeUnsafeSupplier) {
        this._latitudeSupplier = () -> {
            try {
                return (Double)latitudeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="-117.8144595")
    public Double getLongitude() {
        if (this._longitudeSupplier != null) {
            this.longitude = this._longitudeSupplier.get();
            this._longitudeSupplier = null;
        }
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
        this._longitudeSupplier = null;
    }

    @JsonIgnore
    public void setLongitude(UnsafeSupplier<Double, Exception> longitudeUnsafeSupplier) {
        this._longitudeSupplier = () -> {
            try {
                return (Double)longitudeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="0")
    @Valid
    public Number getMvccVersion() {
        if (this._mvccVersionSupplier != null) {
            this.mvccVersion = this._mvccVersionSupplier.get();
            this._mvccVersionSupplier = null;
        }
        return this.mvccVersion;
    }

    public void setMvccVersion(Number mvccVersion) {
        this.mvccVersion = mvccVersion;
        this._mvccVersionSupplier = null;
    }

    @JsonIgnore
    public void setMvccVersion(UnsafeSupplier<Number, Exception> mvccVersionUnsafeSupplier) {
        this._mvccVersionSupplier = () -> {
            try {
                return (Number)mvccVersionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=Warehouse Name US, hr_HR=Warehouse Name HR, hu_HU=Warehouse Name HU}")
    @Valid
    public Map<String, String> getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<Map<String, String>, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (Map)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getPrimary() {
        if (this._primarySupplier != null) {
            this.primary = this._primarySupplier.get();
            this._primarySupplier = null;
        }
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
        this._primarySupplier = null;
    }

    @JsonIgnore
    public void setPrimary(UnsafeSupplier<Boolean, Exception> primaryUnsafeSupplier) {
        this._primarySupplier = () -> {
            try {
                return (Boolean)primaryUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="1400 Montefino Ave")
    public String getStreet1() {
        if (this._street1Supplier != null) {
            this.street1 = this._street1Supplier.get();
            this._street1Supplier = null;
        }
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
        this._street1Supplier = null;
    }

    @JsonIgnore
    public void setStreet1(UnsafeSupplier<String, Exception> street1UnsafeSupplier) {
        this._street1Supplier = () -> {
            try {
                return (String)street1UnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="1st floor")
    public String getStreet2() {
        if (this._street2Supplier != null) {
            this.street2 = this._street2Supplier.get();
            this._street2Supplier = null;
        }
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
        this._street2Supplier = null;
    }

    @JsonIgnore
    public void setStreet2(UnsafeSupplier<String, Exception> street2UnsafeSupplier) {
        this._street2Supplier = () -> {
            try {
                return (String)street2UnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="suite 200")
    public String getStreet3() {
        if (this._street3Supplier != null) {
            this.street3 = this._street3Supplier.get();
            this._street3Supplier = null;
        }
        return this.street3;
    }

    public void setStreet3(String street3) {
        this.street3 = street3;
        this._street3Supplier = null;
    }

    @JsonIgnore
    public void setStreet3(UnsafeSupplier<String, Exception> street3UnsafeSupplier) {
        this._street3Supplier = () -> {
            try {
                return (String)street3UnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="91765")
    public String getZip() {
        if (this._zipSupplier != null) {
            this.zip = this._zipSupplier.get();
            this._zipSupplier = null;
        }
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
        this._zipSupplier = null;
    }

    @JsonIgnore
    public void setZip(UnsafeSupplier<String, Exception> zipUnsafeSupplier) {
        this._zipSupplier = () -> {
            try {
                return (String)zipUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Warehouse)) {
            return false;
        }
        Warehouse warehouse = (Warehouse)object;
        return Objects.equals(this.toString(), warehouse.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String zip;
        String street3;
        String street2;
        String street1;
        Boolean primary;
        Map<String, String> name;
        Number mvccVersion;
        Double longitude;
        Double latitude;
        Long id;
        Long groupId;
        Map<String, String> description;
        Long commerceRegionId;
        Long commerceCountryId;
        String city;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Boolean active = this.getActive();
        if (active != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"active\": ");
            sb.append((Object)active);
        }
        if ((city = this.getCity()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"city\": ");
            sb.append("\"");
            sb.append(Warehouse._escape(city));
            sb.append("\"");
        }
        if ((commerceCountryId = this.getCommerceCountryId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"commerceCountryId\": ");
            sb.append((Object)commerceCountryId);
        }
        if ((commerceRegionId = this.getCommerceRegionId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"commerceRegionId\": ");
            sb.append((Object)commerceRegionId);
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append(Warehouse._toJSON(description));
        }
        if ((groupId = this.getGroupId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"groupId\": ");
            sb.append((Object)groupId);
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((latitude = this.getLatitude()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"latitude\": ");
            sb.append((Object)latitude);
        }
        if ((longitude = this.getLongitude()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"longitude\": ");
            sb.append((Object)longitude);
        }
        if ((mvccVersion = this.getMvccVersion()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"mvccVersion\": ");
            sb.append((Object)mvccVersion);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append(Warehouse._toJSON(name));
        }
        if ((primary = this.getPrimary()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"primary\": ");
            sb.append((Object)primary);
        }
        if ((street1 = this.getStreet1()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"street1\": ");
            sb.append("\"");
            sb.append(Warehouse._escape(street1));
            sb.append("\"");
        }
        if ((street2 = this.getStreet2()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"street2\": ");
            sb.append("\"");
            sb.append(Warehouse._escape(street2));
            sb.append("\"");
        }
        if ((street3 = this.getStreet3()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"street3\": ");
            sb.append("\"");
            sb.append(Warehouse._escape(street3));
            sb.append("\"");
        }
        if ((zip = this.getZip()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"zip\": ");
            sb.append("\"");
            sb.append(Warehouse._escape(zip));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Warehouse._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Warehouse._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Warehouse._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Warehouse._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Warehouse._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

