/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.exception.NoSuchShipmentItemException;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseService;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0.BaseShipmentItemResourceImpl;
import com.liferay.headless.commerce.admin.shipment.internal.util.v1_0.ShipmentItemUtil;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShipmentItemResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/shipment-item.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ShipmentItemResource.class})
public class ShipmentItemResourceImpl
extends BaseShipmentItemResourceImpl {
    @Reference
    private CommerceInventoryWarehouseService _commerceInventoryWarehouseService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;
    @Reference
    private CommerceShipmentService _commerceShipmentService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter.ShipmentItemDTOConverter)")
    private DTOConverter<CommerceShipmentItem, ShipmentItem> _shipmentItemDTOConverter;

    @Override
    public void deleteShipmentItem(Long shipmentItemId) throws Exception {
        this._commerceShipmentItemService.deleteCommerceShipmentItem(shipmentItemId.longValue(), Boolean.FALSE.booleanValue());
    }

    @Override
    public void deleteShipmentItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.fetchCommerceShipmentItemByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipmentItem == null) {
            throw new NoSuchShipmentItemException("Unable to find shipment item with external reference code " + externalReferenceCode);
        }
        this._commerceShipmentItemService.deleteCommerceShipmentItem(commerceShipmentItem.getCommerceShipmentItemId(), Boolean.FALSE.booleanValue());
    }

    @Override
    public ShipmentItem getShipmentByExternalReferenceCodeItem(String externalReferenceCode) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.fetchCommerceShipmentItemByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipmentItem == null) {
            throw new NoSuchShipmentItemException("Unable to find shipment item with external reference code " + externalReferenceCode);
        }
        return this._toShipmentItem(commerceShipmentItem);
    }

    @Override
    public Page<ShipmentItem> getShipmentByExternalReferenceCodeItemsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._commerceShipmentItemService.getCommerceShipmentItems(commerceShipment.getCommerceShipmentId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toShipmentItem), (Pagination)pagination, (long)this._commerceShipmentItemService.getCommerceShipmentItemsCount(commerceShipment.getCommerceShipmentId()));
    }

    @Override
    public ShipmentItem getShipmentItem(Long shipmentItemId) throws Exception {
        return this._toShipmentItem(shipmentItemId);
    }

    @Override
    @NestedField(parentClass=Shipment.class, value="shipmentItems")
    public Page<ShipmentItem> getShipmentItemsPage(@NestedFieldId(value="id") Long shipmentId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._commerceShipmentItemService.getCommerceShipmentItems(shipmentId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toShipmentItem), (Pagination)pagination, (long)this._commerceShipmentItemService.getCommerceShipmentItemsCount(shipmentId.longValue()));
    }

    @Override
    public ShipmentItem patchShipmentItem(Long shipmentItemId, ShipmentItem shipmentItem) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.getCommerceShipmentItem(shipmentItemId.longValue());
        this._commerceShipmentItemService.updateCommerceShipmentItem(shipmentItemId.longValue(), ShipmentItemUtil.getCommerceInventoryWarehouseId(this._commerceInventoryWarehouseService, this.contextCompany.getCompanyId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), shipmentItem), BigDecimalUtil.get((Object)shipmentItem.getQuantity(), (BigDecimal)commerceShipmentItem.getQuantity()), GetterUtil.getBoolean((Object)shipmentItem.getValidateInventory(), (boolean)true));
        if (!Validator.isBlank((String)shipmentItem.getExternalReferenceCode())) {
            this._commerceShipmentItemService.updateExternalReferenceCode(commerceShipmentItem.getCommerceShipmentItemId(), shipmentItem.getExternalReferenceCode());
        }
        return this._toShipmentItem(shipmentItemId);
    }

    @Override
    public ShipmentItem patchShipmentItemByExternalReferenceCode(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.fetchCommerceShipmentItemByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipmentItem == null) {
            throw new NoSuchShipmentItemException("Unable to find shipment item with external reference code " + externalReferenceCode);
        }
        this._commerceShipmentItemService.updateCommerceShipmentItem(commerceShipmentItem.getCommerceShipmentItemId(), ShipmentItemUtil.getCommerceInventoryWarehouseId(this._commerceInventoryWarehouseService, this.contextCompany.getCompanyId(), commerceShipmentItem.getCommerceInventoryWarehouseId(), shipmentItem), BigDecimalUtil.get((Object)shipmentItem.getQuantity(), (BigDecimal)commerceShipmentItem.getQuantity()), GetterUtil.getBoolean((Object)shipmentItem.getValidateInventory(), (boolean)true));
        return this._toShipmentItem(commerceShipmentItem);
    }

    @Override
    public ShipmentItem postShipmentItem(Long shipmentId, ShipmentItem shipmentItem) throws Exception {
        CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.addCommerceShipmentItem(shipmentItem.getExternalReferenceCode(), shipmentId.longValue(), ShipmentItemUtil.getCommerceOrderItemId(this._commerceOrderItemService, this.contextCompany.getCompanyId(), 0L, shipmentItem), ShipmentItemUtil.getCommerceInventoryWarehouseId(this._commerceInventoryWarehouseService, this.contextCompany.getCompanyId(), 0L, shipmentItem), shipmentItem.getQuantity(), null, GetterUtil.getBoolean((Object)shipmentItem.getValidateInventory(), (boolean)true), this._serviceContextHelper.getServiceContext(this.contextUser));
        return this._toShipmentItem(commerceShipmentItem);
    }

    @Override
    public ShipmentItem postShipmentItemByExternalReferenceCode(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        return this.postShipmentItem(commerceShipment.getCommerceShipmentId(), shipmentItem);
    }

    @Override
    public ShipmentItem putShipmentByExternalReferenceCodeItem(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            commerceShipment = this._commerceShipmentService.getCommerceShipment(GetterUtil.getLong((Object)shipmentItem.getShipmentId()));
        }
        return this._toShipmentItem(ShipmentItemUtil.addOrUpdateShipmentItem(this._commerceInventoryWarehouseService, this._commerceOrderItemService, commerceShipment, this._commerceShipmentItemService, shipmentItem.getExternalReferenceCode(), this._serviceContextHelper, shipmentItem));
    }

    private Map<String, Map<String, String>> _getActions(CommerceShipmentItem commerceShipmentItem) {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceShipmentItem.getCommerceShipmentItemId(), "deleteShipmentItem", commerceShipmentItem.getUserId(), "com.liferay.commerce.model.CommerceShipmentItem", commerceShipmentItem.getGroupId())).put((Object)"get", this.addAction("VIEW", commerceShipmentItem.getCommerceShipmentItemId(), "getShipmentItem", commerceShipmentItem.getUserId(), "com.liferay.commerce.model.CommerceShipmentItem", commerceShipmentItem.getGroupId())).put((Object)"update", this.addAction("UPDATE", commerceShipmentItem.getCommerceShipmentItemId(), "patchShipmentItem", commerceShipmentItem.getUserId(), "com.liferay.commerce.model.CommerceShipmentItem", commerceShipmentItem.getGroupId())).build();
    }

    private ShipmentItem _toShipmentItem(CommerceShipmentItem commerceShipmentItem) throws Exception {
        return (ShipmentItem)this._shipmentItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceShipmentItem), this._dtoConverterRegistry, (Object)commerceShipmentItem.getCommerceShipmentItemId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private ShipmentItem _toShipmentItem(long shipmentItemId) throws Exception {
        return this._toShipmentItem(this._commerceShipmentItemService.getCommerceShipmentItem(shipmentItemId));
    }
}

