/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShippingAddress;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=ShippingAddress"}, service={DTOConverter.class})
public class ShippingAddressDTOConverter
implements DTOConverter<CommerceAddress, ShippingAddress> {
    @Reference
    private CommerceAddressService _commerceAddressService;

    public String getContentType() {
        return ShippingAddress.class.getSimpleName();
    }

    public ShippingAddress toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceAddress commerceAddress = this._commerceAddressService.getCommerceAddress(((Long)dtoConverterContext.getId()).longValue());
        return new ShippingAddress(){
            {
                this.setCity(() -> ((CommerceAddress)commerceAddress).getCity());
                this.setCountryISOCode(() -> {
                    Country country = commerceAddress.getCountry();
                    return country.getA2();
                });
                this.setDescription(() -> ((CommerceAddress)commerceAddress).getDescription());
                this.setExternalReferenceCode(() -> ((CommerceAddress)commerceAddress).getExternalReferenceCode());
                this.setId(() -> ((CommerceAddress)commerceAddress).getCommerceAddressId());
                this.setLatitude(() -> ((CommerceAddress)commerceAddress).getLatitude());
                this.setLongitude(() -> ((CommerceAddress)commerceAddress).getLongitude());
                this.setName(() -> ((CommerceAddress)commerceAddress).getName());
                this.setPhoneNumber(() -> ((CommerceAddress)commerceAddress).getPhoneNumber());
                this.setRegionISOCode(() -> ShippingAddressDTOConverter.this._getRegionISOCode(commerceAddress));
                this.setStreet1(() -> ((CommerceAddress)commerceAddress).getStreet1());
                this.setStreet2(() -> ((CommerceAddress)commerceAddress).getStreet2());
                this.setStreet3(() -> ((CommerceAddress)commerceAddress).getStreet3());
                this.setZip(() -> ((CommerceAddress)commerceAddress).getZip());
            }
        };
    }

    private String _getRegionISOCode(CommerceAddress commerceAddress) throws Exception {
        Region region = commerceAddress.getRegion();
        if (region == null) {
            return "";
        }
        return region.getRegionCode();
    }
}

