/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceShipmentItemService;
import com.liferay.commerce.util.CommerceQuantityFormatter;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceShipmentItem"}, service={DTOConverter.class})
public class ShipmentItemDTOConverter
implements DTOConverter<CommerceShipmentItem, ShipmentItem> {
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceQuantityFormatter _commerceQuantityFormatter;
    @Reference
    private CommerceShipmentItemService _commerceShipmentItemService;

    public String getContentType() {
        return ShipmentItem.class.getSimpleName();
    }

    public ShipmentItem toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceShipmentItem commerceShipmentItem = this._commerceShipmentItemService.getCommerceShipmentItem(((Long)dtoConverterContext.getId()).longValue());
        return new ShipmentItem(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setCreateDate(() -> ((CommerceShipmentItem)commerceShipmentItem).getCreateDate());
                this.setExternalReferenceCode(() -> ((CommerceShipmentItem)commerceShipmentItem).getExternalReferenceCode());
                this.setId(() -> ((CommerceShipmentItem)commerceShipmentItem).getCommerceShipmentItemId());
                this.setModifiedDate(() -> ((CommerceShipmentItem)commerceShipmentItem).getModifiedDate());
                this.setOrderItemExternalReferenceCode(() -> {
                    CommerceOrderItem commerceOrderItem = ShipmentItemDTOConverter.this._commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
                    if (commerceOrderItem == null) {
                        return null;
                    }
                    return commerceOrderItem.getExternalReferenceCode();
                });
                this.setOrderItemId(() -> ((CommerceShipmentItem)commerceShipmentItem).getCommerceOrderItemId());
                this.setQuantity(() -> {
                    CommerceOrderItem commerceOrderItem = ShipmentItemDTOConverter.this._commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
                    if (commerceOrderItem == null) {
                        return null;
                    }
                    return ShipmentItemDTOConverter.this._commerceQuantityFormatter.format(commerceOrderItem.getCPInstanceId(), commerceShipmentItem.getQuantity(), commerceOrderItem.getUnitOfMeasureKey());
                });
                this.setShipmentExternalReferenceCode(() -> {
                    CommerceShipment commerceShipment = commerceShipmentItem.getCommerceShipment();
                    return commerceShipment.getExternalReferenceCode();
                });
                this.setShipmentId(() -> ((CommerceShipmentItem)commerceShipmentItem).getCommerceShipmentId());
                this.setUnitOfMeasureKey(() -> ((CommerceShipmentItem)commerceShipmentItem).getUnitOfMeasureKey());
                this.setUserName(() -> ((CommerceShipmentItem)commerceShipmentItem).getUserName());
                this.setWarehouseExternalReferenceCode(() -> {
                    CommerceInventoryWarehouse commerceInventoryWarehouse = ShipmentItemDTOConverter.this._commerceInventoryWarehouseLocalService.fetchCommerceInventoryWarehouse(commerceShipmentItem.getCommerceInventoryWarehouseId());
                    if (commerceInventoryWarehouse == null) {
                        return null;
                    }
                    return commerceInventoryWarehouse.getExternalReferenceCode();
                });
                this.setWarehouseId(() -> commerceShipmentItem.getCommerceInventoryWarehouseId());
            }
        };
    }
}

