/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceShipmentConstants;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Status;
import com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceShipment"}, service={DTOConverter.class})
public class ShipmentDTOConverter
implements DTOConverter<CommerceShipment, Shipment> {
    @Reference
    private CommerceShipmentService _commerceShipmentService;
    @Reference
    private Language _language;

    public String getContentType() {
        return Shipment.class.getSimpleName();
    }

    public Shipment toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(((Long)dtoConverterContext.getId()).longValue());
        return new Shipment(){
            {
                this.setAccountId(() -> ((CommerceShipment)commerceShipment).getCommerceAccountId());
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setCarrier(() -> ((CommerceShipment)commerceShipment).getCarrier());
                this.setCreateDate(() -> ((CommerceShipment)commerceShipment).getCreateDate());
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CommerceShipment.class.getName(), commerceShipment.getCommerceShipmentId(), commerceShipment.getCompanyId(), dtoConverterContext.getLocale()));
                this.setExpectedDate(() -> ((CommerceShipment)commerceShipment).getExpectedDate());
                this.setExternalReferenceCode(() -> ((CommerceShipment)commerceShipment).getExternalReferenceCode());
                this.setId(() -> ((CommerceShipment)commerceShipment).getCommerceShipmentId());
                this.setModifiedDate(() -> ((CommerceShipment)commerceShipment).getModifiedDate());
                this.setShippingAddressId(() -> ((CommerceShipment)commerceShipment).getCommerceAddressId());
                this.setShippingDate(() -> ((CommerceShipment)commerceShipment).getShippingDate());
                this.setShippingMethodId(() -> ((CommerceShipment)commerceShipment).getCommerceShippingMethodId());
                this.setShippingOptionName(() -> ((CommerceShipment)commerceShipment).getShippingOptionName());
                this.setStatus(() -> new Status(){
                    {
                        this.setCode(() -> ((CommerceShipment)commerceShipment).getStatus());
                        this.setLabel(() -> CommerceShipmentConstants.getShipmentStatusLabel((int)commerceShipment.getStatus()));
                        this.setLabel_i18n(() -> ShipmentDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), CommerceShipmentConstants.getShipmentStatusLabel((int)commerceShipment.getStatus())));
                    }
                });
                this.setTrackingNumber(() -> ((CommerceShipment)commerceShipment).getTrackingNumber());
                this.setTrackingURL(() -> ((CommerceShipment)commerceShipment).getTrackingURL());
                this.setUserName(() -> ((CommerceShipment)commerceShipment).getUserName());
            }
        };
    }
}

