/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.shipment.internal.dto.v1_0.converter.ShippingAddressDTOConverter;
import com.liferay.headless.commerce.admin.shipment.internal.resource.v1_0.BaseShippingAddressResourceImpl;
import com.liferay.headless.commerce.admin.shipment.internal.util.v1_0.ShippingAddressUtil;
import com.liferay.headless.commerce.admin.shipment.resource.v1_0.ShippingAddressResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/shipping-address.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ShippingAddressResource.class})
public class ShippingAddressResourceImpl
extends BaseShippingAddressResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceShipmentService _commerceShipmentService;
    @Reference
    private CountryService _countryService;
    @Reference
    private RegionService _regionService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private ShippingAddressDTOConverter _shippingAddressDTOConverter;

    @Override
    public ShippingAddress getShipmentByExternalReferenceCodeShippingAddress(String externalReferenceCode) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        CommerceAddress commerceAddress = this._commerceAddressService.fetchCommerceAddress(commerceShipment.getCommerceAddressId());
        if (commerceAddress == null) {
            return new ShippingAddress();
        }
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=Shipment.class, value="shippingAddress")
    public ShippingAddress getShipmentShippingAddress(@NestedFieldId(value="id") Long shipmentId) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(shipmentId.longValue());
        CommerceAddress commerceAddress = this._commerceAddressService.fetchCommerceAddress(commerceShipment.getCommerceAddressId());
        if (commerceAddress == null) {
            return new ShippingAddress();
        }
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceAddress.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public ShippingAddress patchShipmentByExternalReferenceCodeShippingAddress(String externalReferenceCode, ShippingAddress shippingAddress) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.fetchCommerceShipmentByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceShipment == null) {
            throw new NoSuchShipmentException("Unable to find shipment with external reference code " + externalReferenceCode);
        }
        commerceShipment = ShippingAddressUtil.updateShippingAddress(this._commerceAddressService, this._commerceShipmentService, commerceShipment, this._countryService, this._regionService, shippingAddress, this._serviceContextHelper);
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceShipment.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    public ShippingAddress patchShipmentShippingAddress(Long shipmentId, ShippingAddress shippingAddress) throws Exception {
        CommerceShipment commerceShipment = this._commerceShipmentService.getCommerceShipment(shipmentId.longValue());
        commerceShipment = ShippingAddressUtil.updateShippingAddress(this._commerceAddressService, this._commerceShipmentService, commerceShipment, this._countryService, this._regionService, shippingAddress, this._serviceContextHelper);
        return this._shippingAddressDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceShipment.getCommerceAddressId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

