/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.client.resource.v1_0;

import com.liferay.headless.commerce.admin.shipment.client.dto.v1_0.ShipmentItem;
import com.liferay.headless.commerce.admin.shipment.client.http.HttpInvoker;
import com.liferay.headless.commerce.admin.shipment.client.pagination.Page;
import com.liferay.headless.commerce.admin.shipment.client.pagination.Pagination;
import com.liferay.headless.commerce.admin.shipment.client.problem.Problem;
import com.liferay.headless.commerce.admin.shipment.client.serdes.v1_0.ShipmentItemSerDes;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ShipmentItemResource {
    public static Builder builder() {
        return new Builder();
    }

    public void deleteShipmentItemByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse deleteShipmentItemByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public ShipmentItem getShipmentByExternalReferenceCodeItem(String var1) throws Exception;

    public HttpInvoker.HttpResponse getShipmentByExternalReferenceCodeItemHttpResponse(String var1) throws Exception;

    public ShipmentItem patchShipmentItemByExternalReferenceCode(String var1, ShipmentItem var2) throws Exception;

    public HttpInvoker.HttpResponse patchShipmentItemByExternalReferenceCodeHttpResponse(String var1, ShipmentItem var2) throws Exception;

    public void deleteShipmentItem(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteShipmentItemHttpResponse(Long var1) throws Exception;

    public void deleteShipmentItemBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteShipmentItemBatchHttpResponse(String var1, Object var2) throws Exception;

    public ShipmentItem getShipmentItem(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getShipmentItemHttpResponse(Long var1) throws Exception;

    public ShipmentItem patchShipmentItem(Long var1, ShipmentItem var2) throws Exception;

    public HttpInvoker.HttpResponse patchShipmentItemHttpResponse(Long var1, ShipmentItem var2) throws Exception;

    public Page<ShipmentItem> getShipmentByExternalReferenceCodeItemsPage(String var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getShipmentByExternalReferenceCodeItemsPageHttpResponse(String var1, Pagination var2) throws Exception;

    public ShipmentItem postShipmentItemByExternalReferenceCode(String var1, ShipmentItem var2) throws Exception;

    public HttpInvoker.HttpResponse postShipmentItemByExternalReferenceCodeHttpResponse(String var1, ShipmentItem var2) throws Exception;

    public ShipmentItem putShipmentByExternalReferenceCodeItem(String var1, ShipmentItem var2) throws Exception;

    public HttpInvoker.HttpResponse putShipmentByExternalReferenceCodeItemHttpResponse(String var1, ShipmentItem var2) throws Exception;

    public Page<ShipmentItem> getShipmentItemsPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getShipmentItemsPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public ShipmentItem postShipmentItem(Long var1, ShipmentItem var2) throws Exception;

    public HttpInvoker.HttpResponse postShipmentItemHttpResponse(Long var1, ShipmentItem var2) throws Exception;

    public static class ShipmentItemResourceImpl
    implements ShipmentItemResource {
        private static final Logger _logger = Logger.getLogger(ShipmentItemResource.class.getName());
        private Builder _builder;

        @Override
        public void deleteShipmentItemByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteShipmentItemByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteShipmentItemByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem getShipmentByExternalReferenceCodeItem(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getShipmentByExternalReferenceCodeItemHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getShipmentByExternalReferenceCodeItemHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem patchShipmentItemByExternalReferenceCode(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchShipmentItemByExternalReferenceCodeHttpResponse(externalReferenceCode, shipmentItem);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchShipmentItemByExternalReferenceCodeHttpResponse(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(shipmentItem.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/by-externalReferenceCode/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteShipmentItem(Long shipmentItemId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteShipmentItemHttpResponse(shipmentItemId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteShipmentItemHttpResponse(Long shipmentItemId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/{shipmentItemId}");
            httpInvoker.path("shipmentItemId", shipmentItemId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteShipmentItemBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteShipmentItemBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteShipmentItemBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem getShipmentItem(Long shipmentItemId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getShipmentItemHttpResponse(shipmentItemId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getShipmentItemHttpResponse(Long shipmentItemId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/{shipmentItemId}");
            httpInvoker.path("shipmentItemId", shipmentItemId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem patchShipmentItem(Long shipmentItemId, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchShipmentItemHttpResponse(shipmentItemId, shipmentItem);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchShipmentItemHttpResponse(Long shipmentItemId, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(shipmentItem.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipment-items/{shipmentItemId}");
            httpInvoker.path("shipmentItemId", shipmentItemId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<ShipmentItem> getShipmentByExternalReferenceCodeItemsPage(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getShipmentByExternalReferenceCodeItemsPageHttpResponse(externalReferenceCode, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, ShipmentItemSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getShipmentByExternalReferenceCodeItemsPageHttpResponse(String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipments/by-externalReferenceCode/{externalReferenceCode}/items");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem postShipmentItemByExternalReferenceCode(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postShipmentItemByExternalReferenceCodeHttpResponse(externalReferenceCode, shipmentItem);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postShipmentItemByExternalReferenceCodeHttpResponse(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(shipmentItem.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipments/by-externalReferenceCode/{externalReferenceCode}/items");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem putShipmentByExternalReferenceCodeItem(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putShipmentByExternalReferenceCodeItemHttpResponse(externalReferenceCode, shipmentItem);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putShipmentByExternalReferenceCodeItemHttpResponse(String externalReferenceCode, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(shipmentItem.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipments/by-externalReferenceCode/{externalReferenceCode}/items");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public Page<ShipmentItem> getShipmentItemsPage(Long shipmentId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getShipmentItemsPageHttpResponse(shipmentId, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, ShipmentItemSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getShipmentItemsPageHttpResponse(Long shipmentId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipments/{shipmentId}/items");
            httpInvoker.path("shipmentId", shipmentId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ShipmentItem postShipmentItem(Long shipmentId, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postShipmentItemHttpResponse(shipmentId, shipmentItem);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ShipmentItemSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postShipmentItemHttpResponse(Long shipmentId, ShipmentItem shipmentItem) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(shipmentItem.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-commerce-admin-shipment/v1.0/shipments/{shipmentId}/items");
            httpInvoker.path("shipmentId", shipmentId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private ShipmentItemResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public ShipmentItemResource build() {
            return new ShipmentItemResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

