/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.CustomField;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShipmentItem;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.ShippingAddress;
import com.liferay.headless.commerce.admin.shipment.dto.v1_0.Status;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Shipment")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Shipment")
public class Shipment
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long accountId;
    @JsonIgnore
    private Supplier<Long> _accountIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String carrier;
    @JsonIgnore
    private Supplier<String> _carrierSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date createDate;
    @JsonIgnore
    private Supplier<Date> _createDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @JsonIgnore
    private Supplier<CustomField[]> _customFieldsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date expectedDate;
    @JsonIgnore
    private Supplier<Date> _expectedDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date modifiedDate;
    @JsonIgnore
    private Supplier<Date> _modifiedDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String orderExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _orderExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long orderId;
    @JsonIgnore
    private Supplier<Long> _orderIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ShipmentItem[] shipmentItems;
    @JsonIgnore
    private Supplier<ShipmentItem[]> _shipmentItemsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ShippingAddress shippingAddress;
    @JsonIgnore
    private Supplier<ShippingAddress> _shippingAddressSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long shippingAddressId;
    @JsonIgnore
    private Supplier<Long> _shippingAddressIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date shippingDate;
    @JsonIgnore
    private Supplier<Date> _shippingDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long shippingMethodId;
    @JsonIgnore
    private Supplier<Long> _shippingMethodIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String shippingOptionName;
    @JsonIgnore
    private Supplier<String> _shippingOptionNameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Status status;
    @JsonIgnore
    private Supplier<Status> _statusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String trackingNumber;
    @JsonIgnore
    private Supplier<String> _trackingNumberSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String trackingURL;
    @JsonIgnore
    private Supplier<String> _trackingURLSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String userName;
    @JsonIgnore
    private Supplier<String> _userNameSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.shipment.dto.v1_0.Shipment", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Shipment toDTO(String json) {
        return (Shipment)ObjectMapperUtil.readValue(Shipment.class, (String)json);
    }

    public static Shipment unsafeToDTO(String json) {
        return (Shipment)ObjectMapperUtil.unsafeReadValue(Shipment.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getAccountId() {
        if (this._accountIdSupplier != null) {
            this.accountId = this._accountIdSupplier.get();
            this._accountIdSupplier = null;
        }
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
        this._accountIdSupplier = null;
    }

    @JsonIgnore
    public void setAccountId(UnsafeSupplier<Long, Exception> accountIdUnsafeSupplier) {
        this._accountIdSupplier = () -> {
            try {
                return (Long)accountIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="FedEx")
    public String getCarrier() {
        if (this._carrierSupplier != null) {
            this.carrier = this._carrierSupplier.get();
            this._carrierSupplier = null;
        }
        return this.carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
        this._carrierSupplier = null;
    }

    @JsonIgnore
    public void setCarrier(UnsafeSupplier<String, Exception> carrierUnsafeSupplier) {
        this._carrierSupplier = () -> {
            try {
                return (String)carrierUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Date getCreateDate() {
        if (this._createDateSupplier != null) {
            this.createDate = this._createDateSupplier.get();
            this._createDateSupplier = null;
        }
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
        this._createDateSupplier = null;
    }

    @JsonIgnore
    public void setCreateDate(UnsafeSupplier<Date, Exception> createDateUnsafeSupplier) {
        this._createDateSupplier = () -> {
            try {
                return (Date)createDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public CustomField[] getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (CustomField[])customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Date getExpectedDate() {
        if (this._expectedDateSupplier != null) {
            this.expectedDate = this._expectedDateSupplier.get();
            this._expectedDateSupplier = null;
        }
        return this.expectedDate;
    }

    public void setExpectedDate(Date expectedDate) {
        this.expectedDate = expectedDate;
        this._expectedDateSupplier = null;
    }

    @JsonIgnore
    public void setExpectedDate(UnsafeSupplier<Date, Exception> expectedDateUnsafeSupplier) {
        this._expectedDateSupplier = () -> {
            try {
                return (Date)expectedDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Date getModifiedDate() {
        if (this._modifiedDateSupplier != null) {
            this.modifiedDate = this._modifiedDateSupplier.get();
            this._modifiedDateSupplier = null;
        }
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this._modifiedDateSupplier = null;
    }

    @JsonIgnore
    public void setModifiedDate(UnsafeSupplier<Date, Exception> modifiedDateUnsafeSupplier) {
        this._modifiedDateSupplier = () -> {
            try {
                return (Date)modifiedDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getOrderExternalReferenceCode() {
        if (this._orderExternalReferenceCodeSupplier != null) {
            this.orderExternalReferenceCode = this._orderExternalReferenceCodeSupplier.get();
            this._orderExternalReferenceCodeSupplier = null;
        }
        return this.orderExternalReferenceCode;
    }

    public void setOrderExternalReferenceCode(String orderExternalReferenceCode) {
        this.orderExternalReferenceCode = orderExternalReferenceCode;
        this._orderExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setOrderExternalReferenceCode(UnsafeSupplier<String, Exception> orderExternalReferenceCodeUnsafeSupplier) {
        this._orderExternalReferenceCodeSupplier = () -> {
            try {
                return (String)orderExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getOrderId() {
        if (this._orderIdSupplier != null) {
            this.orderId = this._orderIdSupplier.get();
            this._orderIdSupplier = null;
        }
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
        this._orderIdSupplier = null;
    }

    @JsonIgnore
    public void setOrderId(UnsafeSupplier<Long, Exception> orderIdUnsafeSupplier) {
        this._orderIdSupplier = () -> {
            try {
                return (Long)orderIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ShipmentItem[] getShipmentItems() {
        if (this._shipmentItemsSupplier != null) {
            this.shipmentItems = this._shipmentItemsSupplier.get();
            this._shipmentItemsSupplier = null;
        }
        return this.shipmentItems;
    }

    public void setShipmentItems(ShipmentItem[] shipmentItems) {
        this.shipmentItems = shipmentItems;
        this._shipmentItemsSupplier = null;
    }

    @JsonIgnore
    public void setShipmentItems(UnsafeSupplier<ShipmentItem[], Exception> shipmentItemsUnsafeSupplier) {
        this._shipmentItemsSupplier = () -> {
            try {
                return (ShipmentItem[])shipmentItemsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ShippingAddress getShippingAddress() {
        if (this._shippingAddressSupplier != null) {
            this.shippingAddress = this._shippingAddressSupplier.get();
            this._shippingAddressSupplier = null;
        }
        return this.shippingAddress;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        this._shippingAddressSupplier = null;
    }

    @JsonIgnore
    public void setShippingAddress(UnsafeSupplier<ShippingAddress, Exception> shippingAddressUnsafeSupplier) {
        this._shippingAddressSupplier = () -> {
            try {
                return (ShippingAddress)shippingAddressUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="31130")
    public @DecimalMin(value="0") Long getShippingAddressId() {
        if (this._shippingAddressIdSupplier != null) {
            this.shippingAddressId = this._shippingAddressIdSupplier.get();
            this._shippingAddressIdSupplier = null;
        }
        return this.shippingAddressId;
    }

    public void setShippingAddressId(Long shippingAddressId) {
        this.shippingAddressId = shippingAddressId;
        this._shippingAddressIdSupplier = null;
    }

    @JsonIgnore
    public void setShippingAddressId(UnsafeSupplier<Long, Exception> shippingAddressIdUnsafeSupplier) {
        this._shippingAddressIdSupplier = () -> {
            try {
                return (Long)shippingAddressIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Date getShippingDate() {
        if (this._shippingDateSupplier != null) {
            this.shippingDate = this._shippingDateSupplier.get();
            this._shippingDateSupplier = null;
        }
        return this.shippingDate;
    }

    public void setShippingDate(Date shippingDate) {
        this.shippingDate = shippingDate;
        this._shippingDateSupplier = null;
    }

    @JsonIgnore
    public void setShippingDate(UnsafeSupplier<Date, Exception> shippingDateUnsafeSupplier) {
        this._shippingDateSupplier = () -> {
            try {
                return (Date)shippingDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getShippingMethodId() {
        if (this._shippingMethodIdSupplier != null) {
            this.shippingMethodId = this._shippingMethodIdSupplier.get();
            this._shippingMethodIdSupplier = null;
        }
        return this.shippingMethodId;
    }

    public void setShippingMethodId(Long shippingMethodId) {
        this.shippingMethodId = shippingMethodId;
        this._shippingMethodIdSupplier = null;
    }

    @JsonIgnore
    public void setShippingMethodId(UnsafeSupplier<Long, Exception> shippingMethodIdUnsafeSupplier) {
        this._shippingMethodIdSupplier = () -> {
            try {
                return (Long)shippingMethodIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Standard Delivery")
    public String getShippingOptionName() {
        if (this._shippingOptionNameSupplier != null) {
            this.shippingOptionName = this._shippingOptionNameSupplier.get();
            this._shippingOptionNameSupplier = null;
        }
        return this.shippingOptionName;
    }

    public void setShippingOptionName(String shippingOptionName) {
        this.shippingOptionName = shippingOptionName;
        this._shippingOptionNameSupplier = null;
    }

    @JsonIgnore
    public void setShippingOptionName(UnsafeSupplier<String, Exception> shippingOptionNameUnsafeSupplier) {
        this._shippingOptionNameSupplier = () -> {
            try {
                return (String)shippingOptionNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Status getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Status, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (Status)statusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="123AD-asd")
    public String getTrackingNumber() {
        if (this._trackingNumberSupplier != null) {
            this.trackingNumber = this._trackingNumberSupplier.get();
            this._trackingNumberSupplier = null;
        }
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        this._trackingNumberSupplier = null;
    }

    @JsonIgnore
    public void setTrackingNumber(UnsafeSupplier<String, Exception> trackingNumberUnsafeSupplier) {
        this._trackingNumberSupplier = () -> {
            try {
                return (String)trackingNumberUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Standard Delivery")
    public String getTrackingURL() {
        if (this._trackingURLSupplier != null) {
            this.trackingURL = this._trackingURLSupplier.get();
            this._trackingURLSupplier = null;
        }
        return this.trackingURL;
    }

    public void setTrackingURL(String trackingURL) {
        this.trackingURL = trackingURL;
        this._trackingURLSupplier = null;
    }

    @JsonIgnore
    public void setTrackingURL(UnsafeSupplier<String, Exception> trackingURLUnsafeSupplier) {
        this._trackingURLSupplier = () -> {
            try {
                return (String)trackingURLUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="John")
    public String getUserName() {
        if (this._userNameSupplier != null) {
            this.userName = this._userNameSupplier.get();
            this._userNameSupplier = null;
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this._userNameSupplier = null;
    }

    @JsonIgnore
    public void setUserName(UnsafeSupplier<String, Exception> userNameUnsafeSupplier) {
        this._userNameSupplier = () -> {
            try {
                return (String)userNameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Shipment)) {
            return false;
        }
        Shipment shipment = (Shipment)object;
        return Objects.equals(this.toString(), shipment.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String userName;
        String trackingURL;
        String trackingNumber;
        Status status;
        String shippingOptionName;
        Long shippingMethodId;
        Date shippingDate;
        Long shippingAddressId;
        ShippingAddress shippingAddress;
        ShipmentItem[] shipmentItems;
        Long orderId;
        String orderExternalReferenceCode;
        Date modifiedDate;
        Long id;
        String externalReferenceCode;
        Date expectedDate;
        CustomField[] customFields;
        Date createDate;
        String carrier;
        Map<String, Map<String, String>> actions;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Long accountId = this.getAccountId();
        if (accountId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountId\": ");
            sb.append((Object)accountId);
        }
        if ((actions = this.getActions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Shipment._toJSON(actions));
        }
        if ((carrier = this.getCarrier()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"carrier\": ");
            sb.append("\"");
            sb.append(Shipment._escape(carrier));
            sb.append("\"");
        }
        if ((createDate = this.getCreateDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"createDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(createDate));
            sb.append("\"");
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (int i = 0; i < customFields.length; ++i) {
                sb.append(String.valueOf(customFields[i]));
                if (i + 1 >= customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((expectedDate = this.getExpectedDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"expectedDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(expectedDate));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Shipment._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((modifiedDate = this.getModifiedDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"modifiedDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(modifiedDate));
            sb.append("\"");
        }
        if ((orderExternalReferenceCode = this.getOrderExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(Shipment._escape(orderExternalReferenceCode));
            sb.append("\"");
        }
        if ((orderId = this.getOrderId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderId\": ");
            sb.append((Object)orderId);
        }
        if ((shipmentItems = this.getShipmentItems()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shipmentItems\": ");
            sb.append("[");
            for (int i = 0; i < shipmentItems.length; ++i) {
                sb.append(String.valueOf(shipmentItems[i]));
                if (i + 1 >= shipmentItems.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((shippingAddress = this.getShippingAddress()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingAddress\": ");
            sb.append(String.valueOf(shippingAddress));
        }
        if ((shippingAddressId = this.getShippingAddressId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingAddressId\": ");
            sb.append((Object)shippingAddressId);
        }
        if ((shippingDate = this.getShippingDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(shippingDate));
            sb.append("\"");
        }
        if ((shippingMethodId = this.getShippingMethodId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingMethodId\": ");
            sb.append((Object)shippingMethodId);
        }
        if ((shippingOptionName = this.getShippingOptionName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"shippingOptionName\": ");
            sb.append("\"");
            sb.append(Shipment._escape(shippingOptionName));
            sb.append("\"");
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append(String.valueOf(status));
        }
        if ((trackingNumber = this.getTrackingNumber()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"trackingNumber\": ");
            sb.append("\"");
            sb.append(Shipment._escape(trackingNumber));
            sb.append("\"");
        }
        if ((trackingURL = this.getTrackingURL()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"trackingURL\": ");
            sb.append("\"");
            sb.append(Shipment._escape(trackingURL));
            sb.append("\"");
        }
        if ((userName = this.getUserName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userName\": ");
            sb.append("\"");
            sb.append(Shipment._escape(userName));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Shipment._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Shipment._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Shipment._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Shipment._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Shipment._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

