/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.shipment.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Error")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"errorCode", "errorDescription", "message", "status"})
@XmlRootElement(name="Error")
public class Error
implements Serializable {
    @GraphQLField(description="Internal error code mapping")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotNull
    protected @GraphQLField(description="Internal error code mapping") @NotNull Integer errorCode;
    @JsonIgnore
    private Supplier<Integer> _errorCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotEmpty
    protected String errorDescription;
    @JsonIgnore
    private Supplier<String> _errorDescriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotEmpty
    protected String message;
    @JsonIgnore
    private Supplier<String> _messageSupplier;
    @GraphQLField(description="HTTP Status code")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @NotNull
    protected @GraphQLField(description="HTTP Status code") @NotNull Integer status;
    @JsonIgnore
    private Supplier<Integer> _statusSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.admin.shipment.dto.v1_0.Error", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Error toDTO(String json) {
        return (Error)ObjectMapperUtil.readValue(Error.class, (String)json);
    }

    public static Error unsafeToDTO(String json) {
        return (Error)ObjectMapperUtil.unsafeReadValue(Error.class, (String)json);
    }

    @Schema(description="Internal error code mapping", example="996")
    public Integer getErrorCode() {
        if (this._errorCodeSupplier != null) {
            this.errorCode = this._errorCodeSupplier.get();
            this._errorCodeSupplier = null;
        }
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
        this._errorCodeSupplier = null;
    }

    @JsonIgnore
    public void setErrorCode(UnsafeSupplier<Integer, Exception> errorCodeUnsafeSupplier) {
        this._errorCodeSupplier = () -> {
            try {
                return (Integer)errorCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="Unable to find currency. Currency code should be expressed with 3-letter ISO 4217 format.")
    public String getErrorDescription() {
        if (this._errorDescriptionSupplier != null) {
            this.errorDescription = this._errorDescriptionSupplier.get();
            this._errorDescriptionSupplier = null;
        }
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        this._errorDescriptionSupplier = null;
    }

    @JsonIgnore
    public void setErrorDescription(UnsafeSupplier<String, Exception> errorDescriptionUnsafeSupplier) {
        this._errorDescriptionSupplier = () -> {
            try {
                return (String)errorDescriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="No CommerceCurrency exists with the key {groupId=41811, code=US Dollar}")
    public String getMessage() {
        if (this._messageSupplier != null) {
            this.message = this._messageSupplier.get();
            this._messageSupplier = null;
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this._messageSupplier = null;
    }

    @JsonIgnore
    public void setMessage(UnsafeSupplier<String, Exception> messageUnsafeSupplier) {
        this._messageSupplier = () -> {
            try {
                return (String)messageUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="HTTP Status code", example="404")
    public Integer getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Integer, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (Integer)statusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Error)) {
            return false;
        }
        Error error = (Error)object;
        return Objects.equals(this.toString(), error.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Integer status;
        String message;
        String errorDescription;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Integer errorCode = this.getErrorCode();
        if (errorCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"errorCode\": ");
            sb.append((Object)errorCode);
        }
        if ((errorDescription = this.getErrorDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"errorDescription\": ");
            sb.append("\"");
            sb.append(Error._escape(errorDescription));
            sb.append("\"");
        }
        if ((message = this.getMessage()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"message\": ");
            sb.append("\"");
            sb.append(Error._escape(message));
            sb.append("\"");
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append((Object)status);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Error._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Error._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Error._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Error._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Error._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

