/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.util.v2_0;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProduct;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;

public class DiscountProductUtil {
    public static CommerceDiscountRel addCommerceDiscountRel(CProductLocalService cProductLocalService, CommerceDiscountRelService commerceDiscountRelService, DiscountProduct discountProduct, CommerceDiscount commerceDiscount, ServiceContextHelper serviceContextHelper) throws PortalException {
        CProduct cProduct;
        ServiceContext serviceContext = serviceContextHelper.getServiceContext();
        if (Validator.isNull((String)discountProduct.getProductExternalReferenceCode())) {
            cProduct = cProductLocalService.getCProduct(discountProduct.getProductId().longValue());
        } else {
            cProduct = cProductLocalService.fetchCProductByExternalReferenceCode(discountProduct.getProductExternalReferenceCode(), serviceContext.getCompanyId());
            if (cProduct == null) {
                throw new NoSuchCProductException("Unable to find product with external reference code " + discountProduct.getProductExternalReferenceCode());
            }
        }
        return commerceDiscountRelService.addCommerceDiscountRel(commerceDiscount.getCommerceDiscountId(), CPDefinition.class.getName(), cProduct.getPublishedCPDefinitionId(), serviceContext);
    }
}

