/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.price.list.exception.NoSuchPriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchTierPriceEntryException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.TierPrice;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.TierPriceDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseTierPriceResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.TierPriceUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.TierPriceResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/tier-price.properties"}, scope=ServiceScope.PROTOTYPE, service={TierPriceResource.class})
public class TierPriceResourceImpl
extends BaseTierPriceResourceImpl {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommerceTierPriceEntry)")
    private ModelResourcePermission<CommerceTierPriceEntry> _commerceTierPriceEntryModelResourcePermission;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private TierPriceDTOConverter _tierPriceDTOConverter;

    @Override
    public void deleteTierPrice(Long id) throws Exception {
        this._commerceTierPriceEntryService.deleteCommerceTierPriceEntry(id.longValue());
    }

    @Override
    public void deleteTierPriceByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceTierPriceEntry == null) {
            throw new NoSuchTierPriceEntryException("Unable to find tier price with external reference code " + externalReferenceCode);
        }
        this._commerceTierPriceEntryService.deleteCommerceTierPriceEntry(commerceTierPriceEntry.getCommerceTierPriceEntryId());
    }

    @Override
    public Page<TierPrice> getPriceEntryByExternalReferenceCodeTierPricesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find price entry with external reference code " + externalReferenceCode);
        }
        List commerceTierPriceEntries = this._commerceTierPriceEntryService.getCommerceTierPriceEntries(commercePriceEntry.getCommercePriceEntryId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceTierPriceEntryService.getCommerceTierPriceEntriesCount(commercePriceEntry.getCommercePriceEntryId());
        return Page.of(this._toTierPrices(commerceTierPriceEntries), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<TierPrice> getPriceEntryIdTierPricesPage(Long id, Pagination pagination) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchCommercePriceEntry(id.longValue());
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with id: " + id);
        }
        List commerceTierPriceEntries = this._commerceTierPriceEntryService.getCommerceTierPriceEntries(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceTierPriceEntryService.getCommerceTierPriceEntriesCount(id.longValue());
        return Page.of(this._toTierPrices(commerceTierPriceEntries), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public TierPrice getTierPrice(Long id) throws Exception {
        return this._toTierPrice(GetterUtil.getLong((Object)id));
    }

    @Override
    public TierPrice getTierPriceByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceTierPriceEntry == null) {
            throw new NoSuchTierPriceEntryException("Unable to find tier price with external reference code " + externalReferenceCode);
        }
        return this._toTierPrice(commerceTierPriceEntry.getCommerceTierPriceEntryId());
    }

    @Override
    public Response patchTierPrice(Long id, TierPrice tierPrice) throws Exception {
        this._updateCommerceTierPriceEntry(this._commerceTierPriceEntryService.getCommerceTierPriceEntry(id.longValue()), tierPrice);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchTierPriceByExternalReferenceCode(String externalReferenceCode, TierPrice tierPrice) throws Exception {
        CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceTierPriceEntry == null) {
            throw new NoSuchTierPriceEntryException("Unable to find tier price with external reference code " + externalReferenceCode);
        }
        this._updateCommerceTierPriceEntry(commerceTierPriceEntry, tierPrice);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public TierPrice postPriceEntryByExternalReferenceCodeTierPrice(String externalReferenceCode, TierPrice tierPrice) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find price entry with external reference code " + externalReferenceCode);
        }
        CommerceTierPriceEntry commerceTierPriceEntry = TierPriceUtil.addOrUpdateCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, commercePriceEntry, this._serviceContextHelper);
        return this._toTierPrice(commerceTierPriceEntry.getCommerceTierPriceEntryId());
    }

    @Override
    public TierPrice postPriceEntryIdTierPrice(Long id, TierPrice tierPrice) throws Exception {
        CommerceTierPriceEntry commerceTierPriceEntry = TierPriceUtil.addOrUpdateCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, this._commercePriceEntryService.getCommercePriceEntry(id.longValue()), this._serviceContextHelper);
        return this._toTierPrice(commerceTierPriceEntry.getCommerceTierPriceEntryId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceTierPriceEntry commerceTierPriceEntry) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceTierPriceEntry.getCommerceTierPriceEntryId(), "deleteTierPrice", this._commerceTierPriceEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commerceTierPriceEntry.getCommerceTierPriceEntryId(), "getTierPrice", this._commerceTierPriceEntryModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", commerceTierPriceEntry.getCommerceTierPriceEntryId(), "patchTierPrice", this._commerceTierPriceEntryModelResourcePermission)).build();
    }

    private TierPrice _toTierPrice(Long commerceTierPriceEntryId) throws Exception {
        CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryService.getCommerceTierPriceEntry(commerceTierPriceEntryId.longValue());
        return this._tierPriceDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceTierPriceEntry), this._dtoConverterRegistry, (Object)commerceTierPriceEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<TierPrice> _toTierPrices(List<CommerceTierPriceEntry> commerceTierPriceEntries) throws Exception {
        ArrayList<TierPrice> tierPrices = new ArrayList<TierPrice>();
        for (CommerceTierPriceEntry commerceTierPriceEntry : commerceTierPriceEntries) {
            tierPrices.add(this._toTierPrice(commerceTierPriceEntry.getCommerceTierPriceEntryId()));
        }
        return tierPrices;
    }

    private CommerceTierPriceEntry _updateCommerceTierPriceEntry(CommerceTierPriceEntry commerceTierPriceEntry, TierPrice tierPrice) throws Exception {
        CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)tierPrice.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)tierPrice.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        return this._commerceTierPriceEntryService.updateCommerceTierPriceEntry(commerceTierPriceEntry.getCommerceTierPriceEntryId(), BigDecimal.valueOf(tierPrice.getPrice()), GetterUtil.get((Object)tierPrice.getMinimumQuantity(), (int)commerceTierPriceEntry.getMinQuantity()), commercePriceEntry.isBulkPricing(), GetterUtil.getBoolean((Object)tierPrice.getDiscountDiscovery(), (boolean)true), tierPrice.getDiscountLevel1(), tierPrice.getDiscountLevel2(), tierPrice.getDiscountLevel3(), tierPrice.getDiscountLevel4(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)tierPrice.getNeverExpire(), (boolean)true), serviceContext);
    }
}

