/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountSku;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Sku;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.SkuDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseSkuResourceImpl;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.SkuResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/sku.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, SkuResource.class})
public class SkuResourceImpl
extends BaseSkuResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private SkuDTOConverter _skuDTOConverter;

    @Override
    @NestedField(parentClass=DiscountSku.class, value="sku")
    public Sku getDiscountSkuSku(Long id) throws Exception {
        CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(id.longValue());
        return this._skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commerceDiscountRel.getClassPK(), this.contextAcceptLanguage.getPreferredLocale()));
    }

    @Override
    @NestedField(parentClass=PriceEntry.class, value="sku")
    public Sku getPriceEntryIdSku(Long id) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(id.longValue());
        CPInstance cpInstance = commercePriceEntry.getCPInstance();
        return this._skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpInstance.getCPInstanceId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

