/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.pricing.exception.NoSuchPriceModifierException;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.model.CommercePriceModifierRel;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelService;
import com.liferay.commerce.pricing.service.CommercePriceModifierService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifier;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifierCategory;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceModifierCategoryDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceModifierCategoryResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceModifierCategoryUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceModifierCategoryResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/price-modifier-category.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, PriceModifierCategoryResource.class})
public class PriceModifierCategoryResourceImpl
extends BasePriceModifierCategoryResourceImpl
implements NestedFieldSupport {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.pricing.model.CommercePriceModifierRel)")
    private ModelResourcePermission<CommercePriceModifierRel> _commercePriceModifierRelModelResourcePermission;
    @Reference
    private CommercePriceModifierRelService _commercePriceModifierRelService;
    @Reference
    private CommercePriceModifierService _commercePriceModifierService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceModifierCategoryDTOConverter _priceModifierCategoryDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceModifierCategory(Long id) throws Exception {
        this._commercePriceModifierRelService.deleteCommercePriceModifierRel(id.longValue());
    }

    @Override
    public Page<PriceModifierCategory> getPriceModifierByExternalReferenceCodePriceModifierCategoriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find price modifier with external reference code " + externalReferenceCode);
        }
        List commercePriceModifierRels = this._commercePriceModifierRelService.getCommercePriceModifierRels(commercePriceModifier.getCommercePriceModifierId(), AssetCategory.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceModifierRelService.getCommercePriceModifierRelsCount(commercePriceModifier.getCommercePriceModifierId(), AssetCategory.class.getName());
        return Page.of(this._toPriceModifierCategories(commercePriceModifierRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=PriceModifier.class, value="priceModifierCategories")
    public Page<PriceModifierCategory> getPriceModifierIdPriceModifierCategoriesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commercePriceModifierRels = this._commercePriceModifierRelService.getCategoriesCommercePriceModifierRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceModifierRelService.getCategoriesCommercePriceModifierRelsCount(id.longValue(), search);
        return Page.of(this._toPriceModifierCategories(commercePriceModifierRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceModifierCategory postPriceModifierByExternalReferenceCodePriceModifierCategory(String externalReferenceCode, PriceModifierCategory priceModifierCategory) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find price modifier with external reference code " + externalReferenceCode);
        }
        CommercePriceModifierRel commercePriceModifierRel = PriceModifierCategoryUtil.addCommercePriceModifierRel(this.contextCompany.getGroupId(), this._assetCategoryLocalService, this._commercePriceModifierRelService, priceModifierCategory, commercePriceModifier, this._serviceContextHelper);
        return this._toPriceModifierCategory(commercePriceModifierRel.getCommercePriceModifierRelId());
    }

    @Override
    public PriceModifierCategory postPriceModifierIdPriceModifierCategory(Long id, PriceModifierCategory priceModifierCategory) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = PriceModifierCategoryUtil.addCommercePriceModifierRel(this.contextCompany.getGroupId(), this._assetCategoryLocalService, this._commercePriceModifierRelService, priceModifierCategory, this._commercePriceModifierService.getCommercePriceModifier(id.longValue()), this._serviceContextHelper);
        return this._toPriceModifierCategory(commercePriceModifierRel.getCommercePriceModifierRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceModifierRel commercePriceModifierRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commercePriceModifierRel.getCommercePriceModifierRelId(), "deletePriceModifierCategory", this._commercePriceModifierRelModelResourcePermission)).build();
    }

    private List<PriceModifierCategory> _toPriceModifierCategories(List<CommercePriceModifierRel> commercePriceModifierRels) throws Exception {
        ArrayList<PriceModifierCategory> priceModifierCategories = new ArrayList<PriceModifierCategory>();
        for (CommercePriceModifierRel commercePriceModifierRel : commercePriceModifierRels) {
            priceModifierCategories.add(this._toPriceModifierCategory(commercePriceModifierRel.getCommercePriceModifierRelId()));
        }
        return priceModifierCategories;
    }

    private PriceModifierCategory _toPriceModifierCategory(Long commercePriceModifierRelId) throws Exception {
        CommercePriceModifierRel commercePriceModifierRel = this._commercePriceModifierRelService.getCommercePriceModifierRel(commercePriceModifierRelId.longValue());
        return this._priceModifierCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceModifierRel), this._dtoConverterRegistry, (Object)commercePriceModifierRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

