/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListDiscountRel;
import com.liferay.commerce.price.list.service.CommercePriceListDiscountRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceList;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListDiscount;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceListDiscountDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceListDiscountResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListDiscountUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceListDiscountResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/price-list-discount.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, PriceListDiscountResource.class})
public class PriceListDiscountResourceImpl
extends BasePriceListDiscountResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePriceListDiscountRelService _commercePriceListDiscountRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private PriceListDiscountDTOConverter _priceListDiscountDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceListDiscount(Long id) throws Exception {
        this._commercePriceListDiscountRelService.deleteCommercePriceListDiscountRel(id.longValue());
    }

    @Override
    public Page<PriceListDiscount> getPriceListByExternalReferenceCodePriceListDiscountsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        List commercePriceListDiscountRels = this._commercePriceListDiscountRelService.getCommercePriceListDiscountRels(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceListDiscountRelService.getCommercePriceListDiscountRelsCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceListDiscounts(commercePriceListDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=PriceList.class, value="priceListDiscounts")
    public Page<PriceListDiscount> getPriceListIdPriceListDiscountsPage(Long id, Pagination pagination) throws Exception {
        List commercePriceListDiscountRels = this._commercePriceListDiscountRelService.getCommercePriceListDiscountRels(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceListDiscountRelService.getCommercePriceListDiscountRelsCount(id.longValue());
        return Page.of(this._toPriceListDiscounts(commercePriceListDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceListDiscount postPriceListByExternalReferenceCodePriceListDiscount(String externalReferenceCode, PriceListDiscount priceListDiscount) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        CommercePriceListDiscountRel commercePriceListDiscountRel = PriceListDiscountUtil.addCommercePriceListDiscountRel(this._commerceDiscountService, this._commercePriceListDiscountRelService, priceListDiscount, commercePriceList, this._serviceContextHelper);
        return this._toPriceListDiscount(commercePriceListDiscountRel.getCommercePriceListDiscountRelId());
    }

    @Override
    public PriceListDiscount postPriceListIdPriceListDiscount(Long id, PriceListDiscount priceListDiscount) throws Exception {
        CommercePriceListDiscountRel commercePriceListDiscountRel = PriceListDiscountUtil.addCommercePriceListDiscountRel(this._commerceDiscountService, this._commercePriceListDiscountRelService, priceListDiscount, this._commercePriceListService.getCommercePriceList(id.longValue()), this._serviceContextHelper);
        return this._toPriceListDiscount(commercePriceListDiscountRel.getCommercePriceListDiscountRelId());
    }

    private PriceListDiscount _toPriceListDiscount(Long commercePriceListDiscountRelId) throws Exception {
        return this._priceListDiscountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePriceListDiscountRelId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<PriceListDiscount> _toPriceListDiscounts(List<CommercePriceListDiscountRel> commercePriceListDiscountRels) throws Exception {
        ArrayList<PriceListDiscount> priceListDiscounts = new ArrayList<PriceListDiscount>();
        for (CommercePriceListDiscountRel commercePriceListDiscountRel : commercePriceListDiscountRels) {
            priceListDiscounts.add(this._toPriceListDiscount(commercePriceListDiscountRel.getCommercePriceListDiscountRelId()));
        }
        return priceListDiscounts;
    }
}

