/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.price.list.exception.NoSuchPriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.TierPrice;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceEntryDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.odata.entity.v2_0.PriceEntryEntityModel;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceEntryResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.TierPriceUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceEntryResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/price-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceEntryResource.class})
public class PriceEntryResourceImpl
extends BasePriceEntryResourceImpl {
    private static final EntityModel _entityModel = new PriceEntryEntityModel();
    @Reference(target="(model.class.name=com.liferay.commerce.price.list.model.CommercePriceEntry)")
    private ModelResourcePermission<CommercePriceEntry> _commercePriceEntryModelResourcePermission;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceEntryDTOConverter _priceEntryDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceEntry(Long id) throws Exception {
        this._commercePriceEntryService.deleteCommercePriceEntry(id.longValue());
    }

    @Override
    public void deletePriceEntryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find price entry with external reference code " + externalReferenceCode);
        }
        this._commercePriceEntryService.deleteCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public PriceEntry getPriceEntry(Long id) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(id.longValue());
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public PriceEntry getPriceEntryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find price entry with external reference code " + externalReferenceCode);
        }
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public Page<PriceEntry> getPriceListByExternalReferenceCodePriceEntriesPage(String externalReferenceCode, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        return this.getPriceListIdPriceEntriesPage(commercePriceList.getCommercePriceListId(), search, filter, pagination, sorts);
    }

    @Override
    public Page<PriceEntry> getPriceListIdPriceEntriesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchCommercePriceList(id.longValue());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with id: " + id);
        }
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommercePriceEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("commercePriceListId", (Serializable)id);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toPriceEntry(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public PriceEntry patchPriceEntry(Long id, PriceEntry priceEntry) throws Exception {
        return this._toPriceEntry(this._updatePriceEntry(this._commercePriceEntryService.getCommercePriceEntry(id.longValue()), priceEntry));
    }

    @Override
    public PriceEntry patchPriceEntryByExternalReferenceCode(String externalReferenceCode, PriceEntry priceEntry) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find price entry with external reference code " + externalReferenceCode);
        }
        return this._toPriceEntry(this._updatePriceEntry(commercePriceEntry, priceEntry));
    }

    @Override
    public PriceEntry postPriceListByExternalReferenceCodePriceEntry(String externalReferenceCode, PriceEntry priceEntry) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find price list with external reference code " + externalReferenceCode);
        }
        CommercePriceEntry commercePriceEntry = this._addOrUpdateCommercePriceEntry(commercePriceList, priceEntry);
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public PriceEntry postPriceListIdPriceEntry(Long id, PriceEntry priceEntry) throws Exception {
        CommercePriceEntry commercePriceEntry = this._addOrUpdateCommercePriceEntry(this._commercePriceListService.getCommercePriceList(id.longValue()), priceEntry);
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    private CommercePriceEntry _addOrUpdateCommercePriceEntry(CommercePriceList commercePriceList, PriceEntry priceEntry) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId());
        long cProductId = 0L;
        String cpInstanceUuid = null;
        CPInstance cpInstance = null;
        long skuId = GetterUtil.getLong((Object)priceEntry.getSkuId());
        String skuExternalReferenceCode = priceEntry.getSkuExternalReferenceCode();
        if (skuId > 0L) {
            cpInstance = this._cpInstanceService.fetchCPInstance(skuId);
        } else if (Validator.isNotNull((String)skuExternalReferenceCode)) {
            cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(skuExternalReferenceCode, serviceContext.getCompanyId());
        }
        if (cpInstance != null) {
            CPDefinition cpDefinition = cpInstance.getCPDefinition();
            cProductId = cpDefinition.getCProductId();
            cpInstanceUuid = cpInstance.getCPInstanceUuid();
        }
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)priceEntry.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)priceEntry.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.addOrUpdateCommercePriceEntry(priceEntry.getExternalReferenceCode(), GetterUtil.getLong((Object)priceEntry.getPriceEntryId()), cProductId, cpInstanceUuid, commercePriceList.getCommercePriceListId(), BigDecimal.valueOf(priceEntry.getPrice()), GetterUtil.getBoolean((Object)priceEntry.getDiscountDiscovery(), (boolean)true), priceEntry.getDiscountLevel1(), priceEntry.getDiscountLevel2(), priceEntry.getDiscountLevel3(), priceEntry.getDiscountLevel4(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceEntry.getNeverExpire(), (boolean)true), priceEntry.getSkuExternalReferenceCode(), serviceContext);
        this._updateNestedResources(priceEntry, commercePriceEntry);
        return commercePriceEntry;
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceEntry commercePriceEntry) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commercePriceEntry.getCommercePriceEntryId(), "deletePriceEntry", this._commercePriceEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", commercePriceEntry.getCommercePriceEntryId(), "getPriceEntry", this._commercePriceEntryModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", commercePriceEntry.getCommercePriceEntryId(), "patchPriceEntry", this._commercePriceEntryModelResourcePermission)).build();
    }

    private PriceEntry _toPriceEntry(CommercePriceEntry commercePriceEntry) throws Exception {
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    private PriceEntry _toPriceEntry(Long commercePriceEntryId) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(commercePriceEntryId.longValue());
        return this._priceEntryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceEntry), this._dtoConverterRegistry, (Object)commercePriceEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateNestedResources(PriceEntry priceEntry, CommercePriceEntry commercePriceEntry) throws Exception {
        TierPrice[] tierPrices = priceEntry.getTierPrices();
        if (tierPrices != null) {
            for (TierPrice tierPrice : tierPrices) {
                TierPriceUtil.addOrUpdateCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, commercePriceEntry, this._serviceContextHelper);
            }
        }
    }

    private CommercePriceEntry _updatePriceEntry(CommercePriceEntry commercePriceEntry, PriceEntry priceEntry) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)priceEntry.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)priceEntry.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        commercePriceEntry = this._commercePriceEntryService.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), BigDecimal.valueOf(priceEntry.getPrice()), priceEntry.getDiscountDiscovery().booleanValue(), priceEntry.getDiscountLevel1(), priceEntry.getDiscountLevel2(), priceEntry.getDiscountLevel3(), priceEntry.getDiscountLevel4(), GetterUtil.getBoolean((Object)priceEntry.getBulkPricing(), (boolean)true), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceEntry.getNeverExpire(), (boolean)true), serviceContext);
        this._updateNestedResources(priceEntry, commercePriceEntry);
        return commercePriceEntry;
    }
}

