/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Discount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountSku;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountSkuDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountSkuResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountSkuUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountSkuResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/discount-sku.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountSkuResource.class, NestedFieldSupport.class})
public class DiscountSkuResourceImpl
extends BaseDiscountSkuResourceImpl
implements NestedFieldSupport {
    @Reference(target="(model.class.name=com.liferay.commerce.discount.model.CommerceDiscountRel)")
    private ModelResourcePermission<CommerceDiscountRel> _commerceDiscountRelModelResourcePermission;
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private DiscountSkuDTOConverter _discountSkuDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountSku(Long id) throws Exception {
        this._commerceDiscountRelService.deleteCommerceDiscountRel(id.longValue());
    }

    @Override
    @NestedField(parentClass=Discount.class, value="discountSkus")
    public Page<DiscountSku> getDiscountIdDiscountSkusPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of(this.transform(this._commerceDiscountRelService.getCPInstancesByCommerceDiscountId(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), commerceDiscountRel -> this._toDiscountSku(commerceDiscountRel.getCommerceDiscountRelId())), (Pagination)pagination, (long)this._commerceDiscountRelService.getCPInstancesByCommerceDiscountIdCount(id.longValue(), search));
    }

    @Override
    public DiscountSku postDiscountIdDiscountSku(Long id, DiscountSku discountSku) throws Exception {
        CommerceDiscountRel commerceDiscountRel = DiscountSkuUtil.addCommerceDiscountRel(this._cpInstanceLocalService, this._commerceDiscountRelService, discountSku, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountSku(commerceDiscountRel.getCommerceDiscountRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountRel commerceDiscountRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceDiscountRel.getCommerceDiscountRelId(), "deleteDiscountSku", this._commerceDiscountRelModelResourcePermission)).build();
    }

    private DiscountSku _toDiscountSku(Long commerceDiscountRelId) throws Exception {
        return this._discountSkuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(this._commerceDiscountRelService.getCommerceDiscountRel(commerceDiscountRelId.longValue())), this._dtoConverterRegistry, (Object)commerceDiscountRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

