/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountOrderTypeRel;
import com.liferay.commerce.discount.service.CommerceDiscountOrderTypeRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Discount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountOrderType;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountOrderTypeDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountOrderTypeUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountOrderTypeResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/discount-order-type.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountOrderTypeResource.class, NestedFieldSupport.class})
public class DiscountOrderTypeResourceImpl
extends BaseDiscountOrderTypeResourceImpl
implements NestedFieldSupport {
    @Reference(target="(model.class.name=com.liferay.commerce.discount.model.CommerceDiscountOrderTypeRel)")
    private ModelResourcePermission<CommerceDiscountOrderTypeRel> _commerceDiscountOrderTypeRelModelResourcePermission;
    @Reference
    private CommerceDiscountOrderTypeRelService _commerceDiscountOrderTypeRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private DiscountOrderTypeDTOConverter _discountOrderTypeDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountOrderType(Long id) throws Exception {
        this._commerceDiscountOrderTypeRelService.deleteCommerceDiscountOrderTypeRel(id.longValue());
    }

    @Override
    public Page<DiscountOrderType> getDiscountByExternalReferenceCodeDiscountOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._commerceDiscountOrderTypeRelService.getCommerceDiscountOrderTypeRels(commerceDiscount.getCommerceDiscountId(), "", pagination.getStartPosition(), pagination.getEndPosition(), null), commerceDiscountOrderTypeRel -> this._toDiscountOrderType(commerceDiscountOrderTypeRel.getCommerceDiscountOrderTypeRelId())), (Pagination)pagination, (long)this._commerceDiscountOrderTypeRelService.getCommerceDiscountOrderTypeRelsCount(commerceDiscount.getCommerceDiscountId(), ""));
    }

    @Override
    @NestedField(parentClass=Discount.class, value="discountOrderTypes")
    public Page<DiscountOrderType> getDiscountIdDiscountOrderTypesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of(this.transform(this._commerceDiscountOrderTypeRelService.getCommerceDiscountOrderTypeRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition(), null), commerceDiscountOrderTypeRel -> this._toDiscountOrderType(commerceDiscountOrderTypeRel.getCommerceDiscountOrderTypeRelId())), (Pagination)pagination, (long)this._commerceDiscountOrderTypeRelService.getCommerceDiscountOrderTypeRelsCount(id.longValue(), search));
    }

    @Override
    public DiscountOrderType postDiscountByExternalReferenceCodeDiscountOrderType(String externalReferenceCode, DiscountOrderType discountOrderType) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel = DiscountOrderTypeUtil.addCommerceDiscountOrderTypeRel(commerceDiscount, this._commerceDiscountOrderTypeRelService, this._commerceOrderTypeService, discountOrderType, this._serviceContextHelper);
        return this._toDiscountOrderType(commerceDiscountOrderTypeRel.getCommerceDiscountOrderTypeRelId());
    }

    @Override
    public DiscountOrderType postDiscountIdDiscountOrderType(Long id, DiscountOrderType discountOrderType) throws Exception {
        CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel = DiscountOrderTypeUtil.addCommerceDiscountOrderTypeRel(this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._commerceDiscountOrderTypeRelService, this._commerceOrderTypeService, discountOrderType, this._serviceContextHelper);
        return this._toDiscountOrderType(commerceDiscountOrderTypeRel.getCommerceDiscountOrderTypeRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceDiscountOrderTypeRel.getCommerceDiscountOrderTypeRelId(), "deleteDiscountOrderType", this._commerceDiscountOrderTypeRelModelResourcePermission)).build();
    }

    private DiscountOrderType _toDiscountOrderType(Long commerceDiscountOrderTypeRelId) throws Exception {
        CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel = this._commerceDiscountOrderTypeRelService.getCommerceDiscountOrderTypeRel(commerceDiscountOrderTypeRelId.longValue());
        return this._discountOrderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscountOrderTypeRel), this._dtoConverterRegistry, (Object)commerceDiscountOrderTypeRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

