/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.service.CommerceDiscountRuleService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.DiscountRule;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter.DiscountRuleDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v1_0.BaseDiscountRuleResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v1_0.DiscountRuleUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v1_0.DiscountRuleResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/discount-rule.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountRuleResource.class})
public class DiscountRuleResourceImpl
extends BaseDiscountRuleResourceImpl {
    @Reference
    private CommerceDiscountRuleService _commerceDiscountRuleService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private DiscountRuleDTOConverter _discountRuleDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteDiscountRule(Long id) throws Exception {
        this._commerceDiscountRuleService.deleteCommerceDiscountRule(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<DiscountRule> getDiscountByExternalReferenceCodeDiscountRulesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        List commerceDiscountRules = this._commerceDiscountRuleService.getCommerceDiscountRules(commerceDiscount.getCommerceDiscountId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRuleService.getCommerceDiscountRulesCount(commerceDiscount.getCommerceDiscountId());
        return Page.of(this._toDiscountRules(commerceDiscountRules), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountRule> getDiscountIdDiscountRulesPage(Long id, Pagination pagination) throws Exception {
        List commerceDiscountRules = this._commerceDiscountRuleService.getCommerceDiscountRules(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRuleService.getCommerceDiscountRulesCount(id.longValue());
        return Page.of(this._toDiscountRules(commerceDiscountRules), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountRule getDiscountRule(Long id) throws Exception {
        return this._toDiscountRule(GetterUtil.getLong((Object)id));
    }

    @Override
    public Response patchDiscountRule(Long id, DiscountRule discountRule) throws Exception {
        CommerceDiscountRule commerceDiscountRule = this._commerceDiscountRuleService.getCommerceDiscountRule(id.longValue());
        this._commerceDiscountRuleService.updateCommerceDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId(), discountRule.getType(), GetterUtil.get((String)discountRule.getTypeSettings(), (String)commerceDiscountRule.getTypeSettings()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public DiscountRule postDiscountByExternalReferenceCodeDiscountRule(String externalReferenceCode, DiscountRule discountRule) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find discount with external reference code " + externalReferenceCode);
        }
        CommerceDiscountRule commerceDiscountRule = DiscountRuleUtil.addCommerceDiscountRule(this._commerceDiscountRuleService, discountRule, commerceDiscount, this._serviceContextHelper.getServiceContext());
        return this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId());
    }

    @Override
    public DiscountRule postDiscountIdDiscountRule(Long id, DiscountRule discountRule) throws Exception {
        CommerceDiscountRule commerceDiscountRule = DiscountRuleUtil.addCommerceDiscountRule(this._commerceDiscountRuleService, discountRule, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper.getServiceContext());
        return this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId());
    }

    private DiscountRule _toDiscountRule(Long discountId) throws Exception {
        return this._discountRuleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)discountId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<DiscountRule> _toDiscountRules(List<CommerceDiscountRule> commerceDiscountRules) throws Exception {
        ArrayList<DiscountRule> discountRules = new ArrayList<DiscountRule>();
        for (CommerceDiscountRule commerceDiscountRule : commerceDiscountRules) {
            discountRules.add(this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId()));
        }
        return discountRules;
    }
}

