/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Product;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinition"}, service={DTOConverter.class, ProductDTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private Language _language;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        return new Product(){
            {
                this.id = cpDefinition.getCPDefinitionId();
                this.name = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.sku = ProductDTOConverter.this._getSku(cpDefinition, dtoConverterContext.getLocale());
                this.thumbnail = cpDefinition.getDefaultImageThumbnailSrc(Long.MIN_VALUE);
            }
        };
    }

    private String _getSku(CPDefinition cpDefinition, Locale locale) {
        List cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.isEmpty()) {
            return "";
        }
        if (cpInstances.size() > 1) {
            return this._language.get(locale, "multiple-skus");
        }
        CPInstance cpInstance = (CPInstance)cpInstances.get(0);
        return cpInstance.getSku();
    }
}

