/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountCategory;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.discount.model.CommerceDiscountRel-Category"}, service={DiscountCategoryDTOConverter.class, DTOConverter.class})
public class DiscountCategoryDTOConverter
implements DTOConverter<CommerceDiscountRel, DiscountCategory> {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;

    public String getContentType() {
        return DiscountCategory.class.getSimpleName();
    }

    public DiscountCategory toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(((Long)dtoConverterContext.getId()).longValue());
        final AssetCategory assetCategory = this._assetCategoryService.getCategory(commerceDiscountRel.getClassPK());
        final CommerceDiscount commerceDiscount = commerceDiscountRel.getCommerceDiscount();
        return new DiscountCategory(){
            {
                this.actions = dtoConverterContext.getActions();
                this.categoryExternalReferenceCode = assetCategory.getExternalReferenceCode();
                this.categoryId = assetCategory.getCategoryId();
                this.discountCategoryId = commerceDiscountRel.getCommerceDiscountRelId();
                this.discountExternalReferenceCode = commerceDiscount.getExternalReferenceCode();
                this.discountId = commerceDiscount.getCommerceDiscountId();
            }
        };
    }
}

