/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v1_0.converter;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.pricing.dto.v1_0.Discount;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.discount.model.CommerceDiscount"}, service={DiscountDTOConverter.class, DTOConverter.class})
public class DiscountDTOConverter
implements DTOConverter<CommerceDiscount, Discount> {
    @Reference
    private CommerceDiscountService _commerceDiscountService;

    public String getContentType() {
        return Discount.class.getSimpleName();
    }

    public Discount toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceDiscount commerceDiscount = this._commerceDiscountService.getCommerceDiscount(((Long)dtoConverterContext.getId()).longValue());
        final ExpandoBridge expandoBridge = commerceDiscount.getExpandoBridge();
        return new Discount(){
            {
                this.active = commerceDiscount.isActive();
                this.couponCode = commerceDiscount.getCouponCode();
                this.customFields = expandoBridge.getAttributes();
                this.displayDate = commerceDiscount.getDisplayDate();
                this.expirationDate = commerceDiscount.getExpirationDate();
                this.externalReferenceCode = commerceDiscount.getExternalReferenceCode();
                this.id = commerceDiscount.getCommerceDiscountId();
                this.limitationTimes = commerceDiscount.getLimitationTimes();
                this.limitationType = commerceDiscount.getLimitationType();
                this.maximumDiscountAmount = commerceDiscount.getMaximumDiscountAmount();
                this.numberOfUse = commerceDiscount.getNumberOfUse();
                this.percentageLevel1 = commerceDiscount.getLevel1();
                this.percentageLevel2 = commerceDiscount.getLevel2();
                this.percentageLevel3 = commerceDiscount.getLevel3();
                this.percentageLevel4 = commerceDiscount.getLevel4();
                this.target = commerceDiscount.getTarget();
                this.title = commerceDiscount.getTitle();
                this.useCouponCode = commerceDiscount.isUseCouponCode();
                this.usePercentage = commerceDiscount.isUsePercentage();
            }
        };
    }
}

