/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.factory;

import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceListResource;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(immediate=true, service={PriceListResource.Factory.class})
public class PriceListResourceFactoryImpl
implements PriceListResource.Factory {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private ComponentServiceObjects<PriceListResource> _componentServiceObjects;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference(target="(permission.checker.type=liberal)")
    private PermissionCheckerFactory _liberalPermissionCheckerFactory;
    @Reference
    private UserLocalService _userLocalService;

    public PriceListResource.Builder create() {
        return new PriceListResource.Builder(){
            private boolean _checkPermissions = true;
            private HttpServletRequest _httpServletRequest;
            private Locale _preferredLocale;
            private User _user;

            public PriceListResource build() {
                if (this._user == null) {
                    throw new IllegalArgumentException("User is not set");
                }
                return (PriceListResource)ProxyUtil.newProxyInstance((ClassLoader)PriceListResource.class.getClassLoader(), (Class[])new Class[]{PriceListResource.class}, (proxy, method, arguments) -> PriceListResourceFactoryImpl.this._invoke(method, arguments, this._checkPermissions, this._httpServletRequest, this._preferredLocale, this._user));
            }

            public PriceListResource.Builder checkPermissions(boolean checkPermissions) {
                this._checkPermissions = checkPermissions;
                return this;
            }

            public PriceListResource.Builder httpServletRequest(HttpServletRequest httpServletRequest) {
                this._httpServletRequest = httpServletRequest;
                return this;
            }

            public PriceListResource.Builder preferredLocale(Locale preferredLocale) {
                this._preferredLocale = preferredLocale;
                return this;
            }

            public PriceListResource.Builder user(User user) {
                this._user = user;
                return this;
            }
        };
    }

    @Activate
    protected void activate() {
        PriceListResource.FactoryHolder.factory = this;
    }

    @Deactivate
    protected void deactivate() {
        PriceListResource.FactoryHolder.factory = null;
    }

    private Object _invoke(Method method, Object[] arguments, boolean checkPermissions, HttpServletRequest httpServletRequest, Locale preferredLocale, User user) throws Throwable {
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._liberalPermissionCheckerFactory.create(user));
        }
        PriceListResource priceListResource = (PriceListResource)this._componentServiceObjects.getService();
        priceListResource.setContextAcceptLanguage((AcceptLanguage)new AcceptLanguageImpl(httpServletRequest, preferredLocale, user));
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        priceListResource.setContextCompany(company);
        priceListResource.setContextHttpServletRequest(httpServletRequest);
        priceListResource.setContextUser(user);
        try {
            Object object = method.invoke((Object)priceListResource, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            this._componentServiceObjects.ungetService((Object)priceListResource);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private class AcceptLanguageImpl
    implements AcceptLanguage {
        private final HttpServletRequest _httpServletRequest;
        private final Locale _preferredLocale;
        private final User _user;

        public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Locale preferredLocale, User user) {
            this._httpServletRequest = httpServletRequest;
            this._preferredLocale = preferredLocale;
            this._user = user;
        }

        public List<Locale> getLocales() {
            return Arrays.asList(this.getPreferredLocale());
        }

        public String getPreferredLanguageId() {
            return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
        }

        public Locale getPreferredLocale() {
            Locale locale;
            if (this._preferredLocale != null) {
                return this._preferredLocale;
            }
            if (this._httpServletRequest != null && (locale = (Locale)this._httpServletRequest.getAttribute("LOCALE")) != null) {
                return locale;
            }
            return this._user.getLocale();
        }

        public boolean isAcceptAllLanguages() {
            return false;
        }
    }
}

