/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.pricing.exception.NoSuchPriceModifierException;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelService;
import com.liferay.commerce.pricing.service.CommercePriceModifierService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifier;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceModifierDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceModifierResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceModifierUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceModifierResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/price-modifier.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceModifierResource.class})
public class PriceModifierResourceImpl
extends BasePriceModifierResourceImpl {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommercePriceModifierRelService _commercePriceModifierRelService;
    @Reference
    private CommercePriceModifierService _commercePriceModifierService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceModifierDTOConverter _priceModifierDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceModifier(Long id) throws Exception {
        this._commercePriceModifierService.deleteCommercePriceModifier(id.longValue());
    }

    @Override
    public void deletePriceModifierByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        this._commercePriceModifierService.deleteCommercePriceModifier(commercePriceModifier.getCommercePriceModifierId());
    }

    @Override
    public Page<PriceModifier> getPriceListByExternalReferenceCodePriceModifiersPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePriceModifiers = this._commercePriceModifierService.getCommercePriceModifiers(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceModifierService.getCommercePriceModifiersCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceModifiers(commercePriceModifiers), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceModifier> getPriceListIdPriceModifiersPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commercePriceModifiers = this._commercePriceModifierService.getCommercePriceModifiers(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePriceModifierService.getCommercePriceModifiersCount(id.longValue());
        return Page.of(this._toPriceModifiers(commercePriceModifiers), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public PriceModifier getPriceModifier(Long id) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.getCommercePriceModifier(id.longValue());
        return this._toPriceModifier(commercePriceModifier.getCommercePriceModifierId());
    }

    @Override
    public PriceModifier getPriceModifierByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceModifier(commercePriceModifier.getCommercePriceModifierId());
    }

    @Override
    public Response patchPriceModifier(Long id, PriceModifier priceModifier) throws Exception {
        this._updatePriceModifier(this._commercePriceModifierService.getCommercePriceModifier(id.longValue()), priceModifier);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchPriceModifierByExternalReferenceCode(String externalReferenceCode, PriceModifier priceModifier) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceModifier == null) {
            throw new NoSuchPriceModifierException("Unable to find Price Modifier with externalReferenceCode: " + externalReferenceCode);
        }
        this._updatePriceModifier(commercePriceModifier, priceModifier);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public PriceModifier postPriceListByExternalReferenceCodePriceModifier(String externalReferenceCode, PriceModifier priceModifier) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePriceModifier commercePriceModifier = this._upsertCommercePriceModifier(commercePriceList, priceModifier);
        return this._toPriceModifier(commercePriceModifier.getCommercePriceModifierId());
    }

    @Override
    public PriceModifier postPriceListIdPriceModifier(Long id, PriceModifier priceModifier) throws Exception {
        CommercePriceModifier commercePriceModifier = this._upsertCommercePriceModifier(this._commercePriceListService.getCommercePriceList(id.longValue()), priceModifier);
        return this._toPriceModifier(commercePriceModifier.getCommercePriceModifierId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceModifier commercePriceModifier) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commercePriceModifier.getCommercePriceListId(), "deletePriceModifier", commercePriceModifier.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceModifier.getGroupId())).put((Object)"get", this.addAction("VIEW", commercePriceModifier.getCommercePriceListId(), "getPriceModifier", commercePriceModifier.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceModifier.getGroupId())).put((Object)"update", this.addAction("UPDATE", commercePriceModifier.getCommercePriceListId(), "patchPriceModifier", commercePriceModifier.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceModifier.getGroupId())).build();
    }

    private DateConfig _getDisplayDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            return new DateConfig(CalendarFactoryUtil.getCalendar((TimeZone)timeZone));
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private DateConfig _getExpirationDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
            expirationCalendar.add(2, 1);
            return new DateConfig(expirationCalendar);
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private PriceModifier _toPriceModifier(Long commercePriceModifierId) throws Exception {
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.getCommercePriceModifier(commercePriceModifierId.longValue());
        return this._priceModifierDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceModifier), this._dtoConverterRegistry, (Object)commercePriceModifierId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<PriceModifier> _toPriceModifiers(List<CommercePriceModifier> commercePriceModifiers) throws Exception {
        ArrayList<PriceModifier> priceModifiers = new ArrayList<PriceModifier>();
        for (CommercePriceModifier commercePriceModifier : commercePriceModifiers) {
            priceModifiers.add(this._toPriceModifier(commercePriceModifier.getCommercePriceModifierId()));
        }
        return priceModifiers;
    }

    private void _updateNestedResources(PriceModifier priceModifier, CommercePriceModifier commercePriceModifier) throws Exception {
        PriceModifierUtil.upsertCommercePriceModifierRels(this._assetCategoryLocalService, this._commercePricingClassService, this._cProductLocalService, this._commercePriceModifierRelService, priceModifier, commercePriceModifier, this._serviceContextHelper);
    }

    private CommercePriceModifier _updatePriceModifier(CommercePriceModifier commercePriceModifier, PriceModifier priceModifier) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = this._getDisplayDateConfig(priceModifier.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(priceModifier.getExpirationDate(), serviceContext.getTimeZone());
        commercePriceModifier = this._commercePriceModifierService.updateCommercePriceModifier(commercePriceModifier.getCommercePriceModifierId(), commercePriceModifier.getGroupId(), priceModifier.getTitle(), priceModifier.getTarget(), priceModifier.getPriceListId().longValue(), priceModifier.getModifierType(), priceModifier.getModifierAmount(), priceModifier.getPriority().doubleValue(), GetterUtil.getBoolean((Object)priceModifier.getActive(), (boolean)true), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceModifier, (boolean)true), serviceContext);
        this._updateNestedResources(priceModifier, commercePriceModifier);
        return commercePriceModifier;
    }

    private CommercePriceModifier _upsertCommercePriceModifier(CommercePriceList commercePriceList, PriceModifier priceModifier) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId());
        DateConfig displayDateConfig = this._getDisplayDateConfig(priceModifier.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(priceModifier.getExpirationDate(), serviceContext.getTimeZone());
        CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.upsertCommercePriceModifier(serviceContext.getUserId(), GetterUtil.getLong((Object)priceModifier.getId()), commercePriceList.getGroupId(), priceModifier.getTitle(), priceModifier.getTarget(), commercePriceList.getCommercePriceListId(), priceModifier.getModifierType(), priceModifier.getModifierAmount(), GetterUtil.get((Object)priceModifier.getPriority(), (double)0.0), GetterUtil.getBoolean((Object)priceModifier.getActive(), (boolean)true), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), priceModifier.getExternalReferenceCode(), GetterUtil.getBoolean((Object)priceModifier.getNeverExpire(), (boolean)true), serviceContext);
        this._updateNestedResources(priceModifier, commercePriceModifier);
        return commercePriceModifier;
    }
}

