/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommercePriceListAccountRel;
import com.liferay.commerce.price.list.model.CommercePriceListChannelRel;
import com.liferay.commerce.price.list.model.CommercePriceListCommerceAccountGroupRel;
import com.liferay.commerce.price.list.model.CommercePriceListDiscountRel;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListAccountRelService;
import com.liferay.commerce.price.list.service.CommercePriceListChannelRelService;
import com.liferay.commerce.price.list.service.CommercePriceListCommerceAccountGroupRelService;
import com.liferay.commerce.price.list.service.CommercePriceListDiscountRelService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.service.CommercePriceModifierRelService;
import com.liferay.commerce.pricing.service.CommercePriceModifierService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceList;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListAccount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListAccountGroup;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListChannel;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceListDiscount;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceModifier;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.TierPrice;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceListDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.odata.entity.v2_0.PriceListEntityModel;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceListResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListAccountGroupUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListAccountUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListChannelUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceListDiscountUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.PriceModifierUtil;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.TierPriceUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceListResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/price-list.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceListResource.class})
public class PriceListResourceImpl
extends BasePriceListResourceImpl {
    private static final EntityModel _entityModel = new PriceListEntityModel();
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListAccountRelService _commercePriceListAccountRelService;
    @Reference
    private CommercePriceListChannelRelService _commercePriceListChannelRelService;
    @Reference
    private CommercePriceListCommerceAccountGroupRelService _commercePriceListCommerceAccountGroupRelService;
    @Reference
    private CommercePriceListDiscountRelService _commercePriceListDiscountRelService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommercePriceModifierRelService _commercePriceModifierRelService;
    @Reference
    private CommercePriceModifierService _commercePriceModifierService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceListDTOConverter _priceListDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceList(Long id) throws Exception {
        this._commercePriceListService.deleteCommercePriceList(id.longValue());
    }

    @Override
    public void deletePriceListByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        this._commercePriceListService.deleteCommercePriceList(commercePriceList.getCommercePriceListId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public PriceList getPriceList(Long id) throws Exception {
        return this._toPriceList(GetterUtil.getLong((Object)id));
    }

    @Override
    public PriceList getPriceListByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceList(commercePriceList.getCommercePriceListId());
    }

    @Override
    public Page<PriceList> getPriceListsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CommercePriceList.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
                searchContext.setCompanyId(PriceListResourceImpl.this.contextCompany.getCompanyId());
            }
        }, (Sort[])sorts, document -> this._toPriceList(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public PriceList patchPriceList(Long id, PriceList priceList) throws Exception {
        return this._toPriceList(this._updatePriceList(this._commercePriceListService.getCommercePriceList(id.longValue()), priceList));
    }

    @Override
    public PriceList patchPriceListByExternalReferenceCode(String externalReferenceCode, PriceList priceList) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceList(this._updatePriceList(commercePriceList, priceList));
    }

    @Override
    public PriceList postPriceList(PriceList priceList) throws Exception {
        CommercePriceList commercePriceList = this._upsertPriceList(priceList);
        return this._toPriceList(commercePriceList.getCommercePriceListId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceList commercePriceList) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commercePriceList.getCommercePriceListId(), "deletePriceList", commercePriceList.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).put((Object)"get", this.addAction("VIEW", commercePriceList.getCommercePriceListId(), "getPriceList", commercePriceList.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).put((Object)"permissions", this.addAction("PERMISSIONS", commercePriceList.getCommercePriceListId(), "patchPriceList", commercePriceList.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).put((Object)"update", this.addAction("UPDATE", commercePriceList.getCommercePriceListId(), "patchPriceList", commercePriceList.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).build();
    }

    private DateConfig _getDisplayDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            return new DateConfig(CalendarFactoryUtil.getCalendar((TimeZone)timeZone));
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private DateConfig _getExpirationDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
            expirationCalendar.add(2, 1);
            return new DateConfig(expirationCalendar);
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private PriceList _toPriceList(CommercePriceList commercePriceList) throws Exception {
        return this._toPriceList(commercePriceList.getCommercePriceListId());
    }

    private PriceList _toPriceList(Long commercePriceListId) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.getCommercePriceList(commercePriceListId.longValue());
        return this._priceListDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceList), this._dtoConverterRegistry, (Object)commercePriceListId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CommercePriceList _updateNestedResources(PriceList priceList, CommercePriceList commercePriceList, ServiceContext serviceContext) throws Exception {
        PriceEntry[] priceEntries;
        PriceModifier[] priceModifiers;
        PriceListDiscount[] priceListDiscounts;
        PriceListChannel[] priceListChannels;
        PriceListAccount[] priceListAccounts;
        PriceListAccountGroup[] priceListAccountGroups = priceList.getPriceListAccountGroups();
        if (priceListAccountGroups != null) {
            for (PriceListAccountGroup priceListAccountGroup : priceListAccountGroups) {
                CommercePriceListCommerceAccountGroupRel commercePriceListCommerceAccountGroupRel = this._commercePriceListCommerceAccountGroupRelService.fetchCommercePriceListCommerceAccountGroupRel(commercePriceList.getCommercePriceListId(), priceListAccountGroup.getAccountGroupId().longValue());
                if (commercePriceListCommerceAccountGroupRel != null) continue;
                PriceListAccountGroupUtil.addCommercePriceListCommerceAccountGroupRel(this._commerceAccountGroupService, this._commercePriceListCommerceAccountGroupRelService, priceListAccountGroup, commercePriceList, this._serviceContextHelper);
            }
        }
        if ((priceListAccounts = priceList.getPriceListAccounts()) != null) {
            for (PriceListAccount priceListAccount : priceListAccounts) {
                CommercePriceListAccountRel commercePriceListAccountRel = this._commercePriceListAccountRelService.fetchCommercePriceListAccountRel(commercePriceList.getCommercePriceListId(), priceListAccount.getAccountId().longValue());
                if (commercePriceListAccountRel != null) continue;
                PriceListAccountUtil.addCommercePriceListAccountRel(this._commerceAccountService, this._commercePriceListAccountRelService, priceListAccount, commercePriceList, this._serviceContextHelper);
            }
        }
        if ((priceListChannels = priceList.getPriceListChannels()) != null) {
            for (PriceListChannel priceListChannel : priceListChannels) {
                CommercePriceListChannelRel commercePriceListChannelRel = this._commercePriceListChannelRelService.fetchCommercePriceListChannelRel(commercePriceList.getCommercePriceListId(), priceListChannel.getPriceListId().longValue());
                if (commercePriceListChannelRel != null) continue;
                PriceListChannelUtil.addCommercePriceListChannelRel(this._commerceChannelService, this._commercePriceListChannelRelService, priceListChannel, commercePriceList, this._serviceContextHelper);
            }
        }
        if ((priceListDiscounts = priceList.getPriceListDiscounts()) != null) {
            for (PriceListDiscount priceListDiscount : priceListDiscounts) {
                CommercePriceListDiscountRel commercePriceListDiscountRel = this._commercePriceListDiscountRelService.fetchCommercePriceListDiscountRel(commercePriceList.getCommercePriceListId(), priceListDiscount.getDiscountId().longValue());
                if (commercePriceListDiscountRel != null) continue;
                PriceListDiscountUtil.addCommercePriceListDiscountRel(this._commerceDiscountService, this._commercePriceListDiscountRelService, priceListDiscount, commercePriceList, this._serviceContextHelper);
            }
        }
        if ((priceModifiers = priceList.getPriceModifiers()) != null) {
            for (PriceModifier priceModifier : priceModifiers) {
                DateConfig displayDateConfig = this._getDisplayDateConfig(priceModifier.getDisplayDate(), serviceContext.getTimeZone());
                DateConfig expirationDateConfig = this._getExpirationDateConfig(priceModifier.getExpirationDate(), serviceContext.getTimeZone());
                CommercePriceModifier commercePriceModifier = this._commercePriceModifierService.upsertCommercePriceModifier(serviceContext.getUserId(), GetterUtil.getLong((Object)priceModifier.getId()), commercePriceList.getGroupId(), priceModifier.getTitle(), priceModifier.getTarget(), commercePriceList.getCommercePriceListId(), priceModifier.getModifierType(), priceModifier.getModifierAmount(), GetterUtil.get((Object)priceList.getPriority(), (double)0.0), GetterUtil.getBoolean((Object)priceModifier.getActive(), (boolean)true), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), priceModifier.getExternalReferenceCode(), GetterUtil.getBoolean((Object)priceModifier.getNeverExpire(), (boolean)true), serviceContext);
                PriceModifierUtil.upsertCommercePriceModifierRels(this._assetCategoryLocalService, this._commercePricingClassService, this._cProductLocalService, this._commercePriceModifierRelService, priceModifier, commercePriceModifier, this._serviceContextHelper);
            }
        }
        if ((priceEntries = priceList.getPriceEntries()) != null) {
            for (PriceEntry priceEntry : priceEntries) {
                DateConfig displayDateConfig = this._getDisplayDateConfig(priceEntry.getDisplayDate(), serviceContext.getTimeZone());
                DateConfig expirationDateConfig = this._getExpirationDateConfig(priceEntry.getExpirationDate(), serviceContext.getTimeZone());
                CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.upsertCommercePriceEntry(GetterUtil.getLong((Object)priceEntry.getId()), GetterUtil.getLong((Object)priceEntry.getSkuId()), null, commercePriceList.getCommercePriceListId(), priceEntry.getExternalReferenceCode(), BigDecimal.valueOf(priceEntry.getPrice()), priceEntry.getDiscountDiscovery().booleanValue(), priceEntry.getDiscountLevel1(), priceEntry.getDiscountLevel2(), priceEntry.getDiscountLevel3(), priceEntry.getDiscountLevel4(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceEntry.getNeverExpire(), (boolean)true), priceEntry.getSkuExternalReferenceCode(), serviceContext);
                TierPrice[] tierPrices = priceEntry.getTierPrices();
                if (tierPrices == null) continue;
                for (TierPrice tierPrice : tierPrices) {
                    TierPriceUtil.upsertCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, commercePriceEntry, this._serviceContextHelper);
                }
            }
        }
        return commercePriceList;
    }

    private CommercePriceList _updatePriceList(CommercePriceList commercePriceList, PriceList priceList) throws Exception {
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(this.contextCompany.getCompanyId(), priceList.getCurrencyCode());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId());
        DateConfig displayDateConfig = this._getDisplayDateConfig(priceList.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(priceList.getExpirationDate(), serviceContext.getTimeZone());
        commercePriceList = this._commercePriceListService.updateCommercePriceList(commercePriceList.getCommercePriceListId(), commerceCurrency.getCommerceCurrencyId(), GetterUtil.get((Object)priceList.getNetPrice(), (boolean)commercePriceList.isNetPrice()), GetterUtil.get((Object)priceList.getParentPriceListId(), (long)commercePriceList.getParentCommercePriceListId()), GetterUtil.get((String)priceList.getName(), (String)commercePriceList.getName()), GetterUtil.get((Object)priceList.getPriority(), (double)commercePriceList.getPriority()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceList.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = priceList.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommercePriceList.class, (long)commercePriceList.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(priceList, commercePriceList, serviceContext);
    }

    private CommercePriceList _upsertPriceList(PriceList priceList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.getCommerceCatalog(priceList.getCatalogId().longValue());
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(this.contextCompany.getCompanyId(), priceList.getCurrencyCode());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = this._getDisplayDateConfig(priceList.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(priceList.getExpirationDate(), serviceContext.getTimeZone());
        CommercePriceList commercePriceList = this._commercePriceListService.upsertCommercePriceList(commerceCatalog.getGroupId(), this.contextUser.getUserId(), 0L, commerceCurrency.getCommerceCurrencyId(), GetterUtil.get((Object)priceList.getNetPrice(), (boolean)true), GetterUtil.get((String)priceList.getTypeAsString(), (String)"price-list"), GetterUtil.get((Object)priceList.getParentPriceListId(), (long)0L), GetterUtil.get((Object)priceList.getCatalogBasePriceList(), (boolean)false), priceList.getName(), GetterUtil.get((Object)priceList.getPriority(), (double)0.0), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), priceList.getExternalReferenceCode(), GetterUtil.getBoolean((Object)priceList.getNeverExpire(), (boolean)true), serviceContext);
        Map customFields = priceList.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CommercePriceList.class, (long)commercePriceList.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(priceList, commercePriceList, serviceContext);
    }
}

