/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.price.list.exception.NoSuchPriceEntryException;
import com.liferay.commerce.price.list.exception.NoSuchPriceListException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceEntry;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.TierPrice;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.PriceEntryDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.odata.entity.v2_0.PriceEntryEntityModel;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BasePriceEntryResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.TierPriceUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.PriceEntryResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/price-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={PriceEntryResource.class})
public class PriceEntryResourceImpl
extends BasePriceEntryResourceImpl {
    private static final EntityModel _entityModel = new PriceEntryEntityModel();
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListService _commercePriceListService;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private PriceEntryDTOConverter _priceEntryDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePriceEntry(Long id) throws Exception {
        this._commercePriceEntryService.deleteCommercePriceEntry(id.longValue());
    }

    @Override
    public void deletePriceEntryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with externalReferenceCode: " + externalReferenceCode);
        }
        this._commercePriceEntryService.deleteCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public PriceEntry getPriceEntry(Long id) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(id.longValue());
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public PriceEntry getPriceEntryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public Page<PriceEntry> getPriceListByExternalReferenceCodePriceEntriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePriceEntries = this._commercePriceEntryService.getCommercePriceEntries(commercePriceList.getCommercePriceListId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commercePriceEntryService.getCommercePriceEntriesCount(commercePriceList.getCommercePriceListId());
        return Page.of(this._toPriceEntries(commercePriceEntries), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<PriceEntry> getPriceListIdPriceEntriesPage(final Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchCommercePriceList(id.longValue());
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with id: " + id);
        }
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CommercePriceEntry.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setAttribute("commercePriceListId", (Serializable)id);
                searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
                searchContext.setCompanyId(PriceEntryResourceImpl.this.contextCompany.getCompanyId());
            }
        }, (Sort[])sorts, document -> this._toPriceEntry(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public PriceEntry patchPriceEntry(Long id, PriceEntry priceEntry) throws Exception {
        return this._toPriceEntry(this._updatePriceEntry(this._commercePriceEntryService.getCommercePriceEntry(id.longValue()), priceEntry));
    }

    @Override
    public PriceEntry patchPriceEntryByExternalReferenceCode(String externalReferenceCode, PriceEntry priceEntry) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceEntry == null) {
            throw new NoSuchPriceEntryException("Unable to find Price Entry with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toPriceEntry(this._updatePriceEntry(commercePriceEntry, priceEntry));
    }

    @Override
    public PriceEntry postPriceListByExternalReferenceCodePriceEntry(String externalReferenceCode, PriceEntry priceEntry) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commercePriceList == null) {
            throw new NoSuchPriceListException("Unable to find Price List with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePriceEntry commercePriceEntry = this._upsertCommercePriceEntry(commercePriceList, priceEntry);
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    @Override
    public PriceEntry postPriceListIdPriceEntry(Long id, PriceEntry priceEntry) throws Exception {
        CommercePriceEntry commercePriceEntry = this._upsertCommercePriceEntry(this._commercePriceListService.getCommercePriceList(id.longValue()), priceEntry);
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    private Map<String, Map<String, String>> _getActions(CommercePriceEntry commercePriceEntry) throws Exception {
        CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commercePriceList.getCommercePriceListId(), "deletePriceEntry", commercePriceEntry.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).put((Object)"get", this.addAction("VIEW", commercePriceList.getCommercePriceListId(), "getPriceEntry", commercePriceEntry.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).put((Object)"update", this.addAction("UPDATE", commercePriceList.getCommercePriceListId(), "patchPriceEntry", commercePriceEntry.getUserId(), "com.liferay.commerce.price.list.model.CommercePriceList", commercePriceList.getGroupId())).build();
    }

    private DateConfig _getDisplayDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            return new DateConfig(CalendarFactoryUtil.getCalendar((TimeZone)timeZone));
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private DateConfig _getExpirationDateConfig(Date date, TimeZone timeZone) {
        if (date == null) {
            Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
            expirationCalendar.add(2, 1);
            return new DateConfig(expirationCalendar);
        }
        long time = date.getTime();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)time, (TimeZone)timeZone);
        return new DateConfig(calendar);
    }

    private List<PriceEntry> _toPriceEntries(List<CommercePriceEntry> commercePriceEntries) throws Exception {
        ArrayList<PriceEntry> priceEntries = new ArrayList<PriceEntry>();
        for (CommercePriceEntry commercePriceEntry : commercePriceEntries) {
            priceEntries.add(this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId()));
        }
        return priceEntries;
    }

    private PriceEntry _toPriceEntry(CommercePriceEntry commercePriceEntry) throws Exception {
        return this._toPriceEntry(commercePriceEntry.getCommercePriceEntryId());
    }

    private PriceEntry _toPriceEntry(Long commercePriceEntryId) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getCommercePriceEntry(commercePriceEntryId.longValue());
        return this._priceEntryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commercePriceEntry), this._dtoConverterRegistry, (Object)commercePriceEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateNestedResources(PriceEntry priceEntry, CommercePriceEntry commercePriceEntry) throws Exception {
        TierPrice[] tierPrices = priceEntry.getTierPrices();
        if (tierPrices != null) {
            for (TierPrice tierPrice : tierPrices) {
                TierPriceUtil.upsertCommerceTierPriceEntry(this._commerceTierPriceEntryService, tierPrice, commercePriceEntry, this._serviceContextHelper);
            }
        }
    }

    private CommercePriceEntry _updatePriceEntry(CommercePriceEntry commercePriceEntry, PriceEntry priceEntry) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        DateConfig displayDateConfig = this._getDisplayDateConfig(priceEntry.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(priceEntry.getExpirationDate(), serviceContext.getTimeZone());
        commercePriceEntry = this._commercePriceEntryService.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), BigDecimal.valueOf(priceEntry.getPrice()), priceEntry.getDiscountDiscovery().booleanValue(), priceEntry.getDiscountLevel1(), priceEntry.getDiscountLevel2(), priceEntry.getDiscountLevel3(), priceEntry.getDiscountLevel4(), GetterUtil.getBoolean((Object)priceEntry.getBulkPricing(), (boolean)true), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceEntry.getNeverExpire(), (boolean)true), serviceContext);
        this._updateNestedResources(priceEntry, commercePriceEntry);
        return commercePriceEntry;
    }

    private CommercePriceEntry _upsertCommercePriceEntry(CommercePriceList commercePriceList, PriceEntry priceEntry) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commercePriceList.getGroupId());
        long cProductId = 0L;
        String cpInstanceUuid = null;
        CPInstance cpInstance = null;
        long skuId = GetterUtil.getLong((Object)priceEntry.getSkuId());
        String skuExternalReferenceCode = priceEntry.getSkuExternalReferenceCode();
        if (skuId > 0L) {
            cpInstance = this._cpInstanceService.fetchCPInstance(skuId);
        } else if (Validator.isNotNull((String)skuExternalReferenceCode)) {
            cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(serviceContext.getCompanyId(), skuExternalReferenceCode);
        }
        if (cpInstance != null) {
            CPDefinition cpDefinition = cpInstance.getCPDefinition();
            cProductId = cpDefinition.getCProductId();
            cpInstanceUuid = cpInstance.getCPInstanceUuid();
        }
        DateConfig displayDateConfig = this._getDisplayDateConfig(priceEntry.getDisplayDate(), serviceContext.getTimeZone());
        DateConfig expirationDateConfig = this._getExpirationDateConfig(priceEntry.getExpirationDate(), serviceContext.getTimeZone());
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.upsertCommercePriceEntry(GetterUtil.getLong((Object)priceEntry.getId()), cProductId, cpInstanceUuid, commercePriceList.getCommercePriceListId(), priceEntry.getExternalReferenceCode(), BigDecimal.valueOf(priceEntry.getPrice()), GetterUtil.getBoolean((Object)priceEntry.getDiscountDiscovery(), (boolean)true), priceEntry.getDiscountLevel1(), priceEntry.getDiscountLevel2(), priceEntry.getDiscountLevel3(), priceEntry.getDiscountLevel4(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)priceEntry.getNeverExpire(), (boolean)true), priceEntry.getSkuExternalReferenceCode(), serviceContext);
        this._updateNestedResources(priceEntry, commercePriceEntry);
        return commercePriceEntry;
    }
}

