/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.service.CommerceDiscountRuleService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountRule;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountRuleDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountRuleResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountRuleUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountRuleResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/discount-rule.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountRuleResource.class})
public class DiscountRuleResourceImpl
extends BaseDiscountRuleResourceImpl {
    @Reference
    private CommerceDiscountRuleService _commerceDiscountRuleService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private DiscountRuleDTOConverter _discountRuleDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountRule(Long id) throws Exception {
        this._commerceDiscountRuleService.deleteCommerceDiscountRule(id.longValue());
    }

    @Override
    public Page<DiscountRule> getDiscountByExternalReferenceCodeDiscountRulesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceDiscountRules = this._commerceDiscountRuleService.getCommerceDiscountRules(commerceDiscount.getCommerceDiscountId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRuleService.getCommerceDiscountRulesCount(commerceDiscount.getCommerceDiscountId());
        return Page.of(this._toDiscountRules(commerceDiscountRules), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountRule> getDiscountIdDiscountRulesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commerceDiscountRules = this._commerceDiscountRuleService.getCommerceDiscountRules(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceDiscountRuleService.getCommerceDiscountRulesCount(id.longValue(), search);
        return Page.of(this._toDiscountRules(commerceDiscountRules), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountRule getDiscountRule(Long id) throws Exception {
        return this._toDiscountRule(GetterUtil.getLong((Object)id));
    }

    @Override
    public DiscountRule patchDiscountRule(Long id, DiscountRule discountRule) throws Exception {
        CommerceDiscountRule commerceDiscountRule = this._commerceDiscountRuleService.getCommerceDiscountRule(id.longValue());
        return this._toDiscountRule(this._commerceDiscountRuleService.updateCommerceDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId(), GetterUtil.get((String)discountRule.getName(), (String)commerceDiscountRule.getName()), discountRule.getType(), GetterUtil.get((String)discountRule.getTypeSettings(), (String)commerceDiscountRule.getTypeSettings())));
    }

    @Override
    public DiscountRule postDiscountByExternalReferenceCodeDiscountRule(String externalReferenceCode, DiscountRule discountRule) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceDiscountRule commerceDiscountRule = DiscountRuleUtil.addCommerceDiscountRule(this._commerceDiscountRuleService, discountRule, commerceDiscount, this._serviceContextHelper);
        return this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId());
    }

    @Override
    public DiscountRule postDiscountIdDiscountRule(Long id, DiscountRule discountRule) throws Exception {
        CommerceDiscountRule commerceDiscountRule = DiscountRuleUtil.addCommerceDiscountRule(this._commerceDiscountRuleService, discountRule, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountRule commerceDiscountRule) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        CommerceDiscount commerceDiscount = this._commerceDiscountService.getCommerceDiscount(commerceDiscountRule.getCommerceDiscountId());
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceDiscount.getCommerceDiscountId(), "deleteDiscountRule", commerceDiscountRule.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).put((Object)"get", this.addAction("VIEW", commerceDiscount.getCommerceDiscountId(), "getDiscountRule", commerceDiscountRule.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).put((Object)"update", this.addAction("UPDATE", commerceDiscount.getCommerceDiscountId(), "patchDiscountRule", commerceDiscountRule.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId())).build();
    }

    private DiscountRule _toDiscountRule(CommerceDiscountRule commerceDiscountRule) throws Exception {
        return this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId());
    }

    private DiscountRule _toDiscountRule(Long commerceDiscountRuleId) throws Exception {
        CommerceDiscountRule commerceDiscountRule = this._commerceDiscountRuleService.getCommerceDiscountRule(commerceDiscountRuleId.longValue());
        return this._discountRuleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscountRule), this._dtoConverterRegistry, (Object)commerceDiscountRuleId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<DiscountRule> _toDiscountRules(List<CommerceDiscountRule> commerceDiscountRules) throws Exception {
        ArrayList<DiscountRule> discountRules = new ArrayList<DiscountRule>();
        for (CommerceDiscountRule commerceDiscountRule : commerceDiscountRules) {
            discountRules.add(this._toDiscountRule(commerceDiscountRule.getCommerceDiscountRuleId()));
        }
        return discountRules;
    }
}

