/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProduct;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountProductDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountProductResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountProductUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/discount-product.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountProductResource.class})
public class DiscountProductResourceImpl
extends BaseDiscountProductResourceImpl {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private DiscountProductDTOConverter _discountProductDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountProduct(Long id) throws Exception {
        this._commerceDiscountRelService.deleteCommerceDiscountRel(id.longValue());
    }

    @Override
    public Page<DiscountProduct> getDiscountByExternalReferenceCodeDiscountProductsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), CPDefinition.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(commerceDiscount.getCommerceDiscountId(), CPDefinition.class.getName());
        return Page.of(this._toDiscountProducts(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountProduct> getDiscountIdDiscountProductsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Locale locale = this.contextAcceptLanguage.getPreferredLocale();
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        List commerceDiscountRels = this._commerceDiscountRelService.getCPDefinitionsByCommerceDiscountId(id.longValue(), search, languageId, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceDiscountRelService.getCPDefinitionsByCommerceDiscountIdCount(id.longValue(), search, languageId);
        return Page.of(this._toDiscountProducts(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountProduct postDiscountByExternalReferenceCodeDiscountProduct(String externalReferenceCode, DiscountProduct discountProduct) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceDiscountRel commerceDiscountRel = DiscountProductUtil.addCommerceDiscountRel(this._cProductLocalService, this._commerceDiscountRelService, discountProduct, commerceDiscount, this._serviceContextHelper);
        return this._toDiscountProduct(commerceDiscountRel.getCommerceDiscountRelId());
    }

    @Override
    public DiscountProduct postDiscountIdDiscountProduct(Long id, DiscountProduct discountProduct) throws Exception {
        CommerceDiscountRel commerceDiscountRel = DiscountProductUtil.addCommerceDiscountRel(this._cProductLocalService, this._commerceDiscountRelService, discountProduct, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountProduct(commerceDiscountRel.getCommerceDiscountRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountRel commerceDiscountRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", () -> {
            ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
            CommerceDiscount commerceDiscount = commerceDiscountRel.getCommerceDiscount();
            return this.addAction("UPDATE", commerceDiscount.getCommerceDiscountId(), "deleteDiscountProduct", commerceDiscountRel.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId());
        }).build();
    }

    private DiscountProduct _toDiscountProduct(Long commerceDiscountRelId) throws Exception {
        CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(commerceDiscountRelId.longValue());
        return this._discountProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscountRel), this._dtoConverterRegistry, (Object)commerceDiscountRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<DiscountProduct> _toDiscountProducts(List<CommerceDiscountRel> commerceDiscountRels) throws Exception {
        ArrayList<DiscountProduct> discountProducts = new ArrayList<DiscountProduct>();
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            discountProducts.add(this._toDiscountProduct(commerceDiscountRel.getCommerceDiscountRelId()));
        }
        return discountProducts;
    }
}

