/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.CommerceDiscountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountProductGroup;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountProductGroupDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountProductGroupResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountProductGroupUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountProductGroupResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/discount-product-group.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountProductGroupResource.class})
public class DiscountProductGroupResourceImpl
extends BaseDiscountProductGroupResourceImpl {
    @Reference
    private CommerceDiscountRelService _commerceDiscountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private DiscountProductGroupDTOConverter _discountProductGroupDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountProductGroup(Long id) throws Exception {
        this._commerceDiscountRelService.deleteCommerceDiscountRel(id.longValue());
    }

    @Override
    public Page<DiscountProductGroup> getDiscountByExternalReferenceCodeDiscountProductGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceDiscountRels = this._commerceDiscountRelService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), CommercePricingClass.class.getName(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountRelService.getCommerceDiscountRelsCount(commerceDiscount.getCommerceDiscountId(), CommercePricingClass.class.getName());
        return Page.of(this._toDiscountProductGroups(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountProductGroup> getDiscountIdDiscountProductGroupsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commerceDiscountRels = this._commerceDiscountRelService.getCommercePricingClassesByCommerceDiscountId(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceDiscountRelService.getCommercePricingClassesByCommerceDiscountIdCount(id.longValue(), search);
        return Page.of(this._toDiscountProductGroups(commerceDiscountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountProductGroup postDiscountByExternalReferenceCodeDiscountProductGroup(String externalReferenceCode, DiscountProductGroup discountProductGroup) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceDiscountRel commerceDiscountRel = DiscountProductGroupUtil.addCommerceDiscountRel(this._commercePricingClassService, this._commerceDiscountRelService, discountProductGroup, commerceDiscount, this._serviceContextHelper);
        return this._toDiscountProductGroup(commerceDiscountRel.getCommerceDiscountRelId());
    }

    @Override
    public DiscountProductGroup postDiscountIdDiscountProductGroup(Long id, DiscountProductGroup discountProductGroup) throws Exception {
        CommerceDiscountRel commerceDiscountRel = DiscountProductGroupUtil.addCommerceDiscountRel(this._commercePricingClassService, this._commerceDiscountRelService, discountProductGroup, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountProductGroup(commerceDiscountRel.getCommerceDiscountRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountRel commerceDiscountRel) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        return HashMapBuilder.put((Object)"delete", () -> {
            CommerceDiscount commerceDiscount = commerceDiscountRel.getCommerceDiscount();
            return this.addAction("UPDATE", commerceDiscount.getCommerceDiscountId(), "deleteDiscountProductGroup", commerceDiscountRel.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId());
        }).build();
    }

    private DiscountProductGroup _toDiscountProductGroup(Long commerceDiscountRelId) throws Exception {
        CommerceDiscountRel commerceDiscountRel = this._commerceDiscountRelService.getCommerceDiscountRel(commerceDiscountRelId.longValue());
        return this._discountProductGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscountRel), this._dtoConverterRegistry, (Object)commerceDiscountRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<DiscountProductGroup> _toDiscountProductGroups(List<CommerceDiscountRel> commerceDiscountRels) throws Exception {
        ArrayList<DiscountProductGroup> discountProductGroups = new ArrayList<DiscountProductGroup>();
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            discountProductGroups.add(this._toDiscountProductGroup(commerceDiscountRel.getCommerceDiscountRelId()));
        }
        return discountProductGroups;
    }
}

