/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0;

import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRel;
import com.liferay.commerce.discount.service.CommerceDiscountAccountRelService;
import com.liferay.commerce.discount.service.CommerceDiscountService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.DiscountAccount;
import com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter.DiscountAccountDTOConverter;
import com.liferay.headless.commerce.admin.pricing.internal.resource.v2_0.BaseDiscountAccountResourceImpl;
import com.liferay.headless.commerce.admin.pricing.internal.util.v2_0.DiscountAccountUtil;
import com.liferay.headless.commerce.admin.pricing.resource.v2_0.DiscountAccountResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v2_0/discount-account.properties"}, scope=ServiceScope.PROTOTYPE, service={DiscountAccountResource.class})
public class DiscountAccountResourceImpl
extends BaseDiscountAccountResourceImpl {
    @Reference
    private CommerceAccountService _commerceAccountService;
    @Reference
    private CommerceDiscountAccountRelService _commerceDiscountAccountRelService;
    @Reference
    private CommerceDiscountService _commerceDiscountService;
    @Reference
    private DiscountAccountDTOConverter _discountAccountDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteDiscountAccount(Long id) throws Exception {
        this._commerceDiscountAccountRelService.deleteCommerceDiscountAccountRel(id.longValue());
    }

    @Override
    public Page<DiscountAccount> getDiscountByExternalReferenceCodeDiscountAccountsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        List commerceDiscountAccountRels = this._commerceDiscountAccountRelService.getCommerceDiscountAccountRels(commerceDiscount.getCommerceDiscountId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commerceDiscountAccountRelService.getCommerceDiscountAccountRelsCount(commerceDiscount.getCommerceDiscountId());
        return Page.of(this._toDiscountAccounts(commerceDiscountAccountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<DiscountAccount> getDiscountIdDiscountAccountsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        List commerceDiscountAccountRels = this._commerceDiscountAccountRelService.getCommerceDiscountAccountRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._commerceDiscountAccountRelService.getCommerceDiscountAccountRelsCount(id.longValue(), search);
        return Page.of(this._toDiscountAccounts(commerceDiscountAccountRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public DiscountAccount postDiscountByExternalReferenceCodeDiscountAccount(String externalReferenceCode, DiscountAccount discountAccount) throws Exception {
        CommerceDiscount commerceDiscount = this._commerceDiscountService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceDiscount == null) {
            throw new NoSuchDiscountException("Unable to find Discount with externalReferenceCode: " + externalReferenceCode);
        }
        CommerceDiscountAccountRel commerceDiscountAccountRel = DiscountAccountUtil.addCommerceDiscountAccountRel(this._commerceAccountService, this._commerceDiscountAccountRelService, discountAccount, commerceDiscount, this._serviceContextHelper);
        return this._toDiscountAccount(commerceDiscountAccountRel.getCommerceDiscountAccountRelId());
    }

    @Override
    public DiscountAccount postDiscountIdDiscountAccount(Long id, DiscountAccount discountAccount) throws Exception {
        CommerceDiscountAccountRel commerceDiscountAccountRel = DiscountAccountUtil.addCommerceDiscountAccountRel(this._commerceAccountService, this._commerceDiscountAccountRelService, discountAccount, this._commerceDiscountService.getCommerceDiscount(id.longValue()), this._serviceContextHelper);
        return this._toDiscountAccount(commerceDiscountAccountRel.getCommerceDiscountAccountRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceDiscountAccountRel commerceDiscountAccountRel) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        return HashMapBuilder.put((Object)"delete", () -> {
            CommerceDiscount commerceDiscount = commerceDiscountAccountRel.getCommerceDiscount();
            return this.addAction("UPDATE", commerceDiscount.getCommerceDiscountId(), "deleteDiscountAccount", commerceDiscountAccountRel.getUserId(), "com.liferay.commerce.discount.model.CommerceDiscount", serviceContext.getScopeGroupId());
        }).build();
    }

    private DiscountAccount _toDiscountAccount(Long commerceDiscountAccountRelId) throws Exception {
        CommerceDiscountAccountRel commerceDiscountAccountRel = this._commerceDiscountAccountRelService.getCommerceDiscountAccountRel(commerceDiscountAccountRelId.longValue());
        return this._discountAccountDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceDiscountAccountRel), this._dtoConverterRegistry, (Object)commerceDiscountAccountRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<DiscountAccount> _toDiscountAccounts(List<CommerceDiscountAccountRel> commerceDiscountAccountRels) throws Exception {
        ArrayList<DiscountAccount> discountAccounts = new ArrayList<DiscountAccount>();
        for (CommerceDiscountAccountRel commerceDiscountAccountRel : commerceDiscountAccountRels) {
            discountAccounts.add(this._toDiscountAccount(commerceDiscountAccountRel.getCommerceDiscountAccountRelId()));
        }
        return discountAccounts;
    }
}

