/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.model.CommerceTierPriceEntry;
import com.liferay.commerce.price.list.service.CommerceTierPriceEntryService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.TierPrice;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommerceTierPriceEntry"}, service={DTOConverter.class, TierPriceDTOConverter.class})
public class TierPriceDTOConverter
implements DTOConverter<CommerceTierPriceEntry, TierPrice> {
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceTierPriceEntryService _commerceTierPriceEntryService;

    public String getContentType() {
        return TierPrice.class.getSimpleName();
    }

    public TierPrice toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceTierPriceEntry commerceTierPriceEntry = this._commerceTierPriceEntryService.getCommerceTierPriceEntry(((Long)dtoConverterContext.getId()).longValue());
        final CommercePriceEntry commercePriceEntry = commerceTierPriceEntry.getCommercePriceEntry();
        CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
        final CommerceCurrency commerceCurrency = commercePriceList.getCommerceCurrency();
        final ExpandoBridge expandoBridge = commerceTierPriceEntry.getExpandoBridge();
        final BigDecimal tierPriceEntryPrice = commerceTierPriceEntry.getPrice();
        final Locale locale = dtoConverterContext.getLocale();
        return new TierPrice(){
            {
                this.actions = dtoConverterContext.getActions();
                this.customFields = expandoBridge.getAttributes();
                this.discountDiscovery = commerceTierPriceEntry.isDiscountDiscovery();
                this.discountLevel1 = commerceTierPriceEntry.getDiscountLevel1();
                this.discountLevel2 = commerceTierPriceEntry.getDiscountLevel2();
                this.discountLevel3 = commerceTierPriceEntry.getDiscountLevel3();
                this.discountLevel4 = commerceTierPriceEntry.getDiscountLevel4();
                this.displayDate = commerceTierPriceEntry.getDisplayDate();
                this.expirationDate = commerceTierPriceEntry.getExpirationDate();
                this.externalReferenceCode = commerceTierPriceEntry.getExternalReferenceCode();
                this.id = commerceTierPriceEntry.getCommerceTierPriceEntryId();
                this.minimumQuantity = commerceTierPriceEntry.getMinQuantity();
                this.price = tierPriceEntryPrice.doubleValue();
                this.priceEntryExternalReferenceCode = commercePriceEntry.getExternalReferenceCode();
                this.priceEntryId = commercePriceEntry.getCommercePriceEntryId();
                this.priceFormatted = TierPriceDTOConverter.this._formatPrice(tierPriceEntryPrice, commerceCurrency, locale);
            }
        };
    }

    private String _formatPrice(BigDecimal price, CommerceCurrency commerceCurrency, Locale locale) throws Exception {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return this._commercePriceFormatter.format(commerceCurrency, price, locale);
    }
}

