/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Sku;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class, SkuDTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.fetchCPInstance(((Long)dtoConverterContext.getId()).longValue());
        final CommercePriceEntry commerceBasePriceListPriceEntry = this._commercePriceEntryService.getInstanceBaseCommercePriceEntry(cpInstance.getCPInstanceUuid(), "price-list");
        final CommercePriceEntry commerceBasePromotionPriceEntry = this._commercePriceEntryService.getInstanceBaseCommercePriceEntry(cpInstance.getCPInstanceUuid(), "promotion");
        final Locale locale = dtoConverterContext.getLocale();
        return new Sku(){
            {
                this.basePrice = SkuDTOConverter.this._getPrice(commerceBasePriceListPriceEntry);
                this.basePriceFormatted = SkuDTOConverter.this._formatPrice(cpInstance.getCompanyId(), commerceBasePriceListPriceEntry, locale);
                this.basePromoPrice = SkuDTOConverter.this._getPrice(commerceBasePromotionPriceEntry);
                this.basePromoPriceFormatted = SkuDTOConverter.this._formatPrice(cpInstance.getCompanyId(), commerceBasePromotionPriceEntry, locale);
                this.id = cpInstance.getCPInstanceId();
                this.name = cpInstance.getSku();
            }
        };
    }

    private String _formatPrice(long companyId, CommercePriceEntry priceEntry, Locale locale) throws Exception {
        if (priceEntry == null) {
            CommerceCurrency commerceCurrency = this._commerceCurrencyService.fetchPrimaryCommerceCurrency(companyId);
            return this._commercePriceFormatter.format(commerceCurrency, BigDecimal.ZERO, locale);
        }
        CommercePriceList commercePriceList = priceEntry.getCommercePriceList();
        return this._commercePriceFormatter.format(commercePriceList.getCommerceCurrency(), priceEntry.getPrice(), locale);
    }

    private double _getPrice(CommercePriceEntry commercePriceEntry) {
        if (commercePriceEntry == null) {
            return 0.0;
        }
        BigDecimal price = commercePriceEntry.getPrice();
        return price.doubleValue();
    }
}

