/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListService;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.PriceList;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Status;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.price.list.model.CommercePriceList"}, service={DTOConverter.class, PriceListDTOConverter.class})
public class PriceListDTOConverter
implements DTOConverter<CommercePriceList, PriceList> {
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CommercePriceListService _commercePriceListService;

    public String getContentType() {
        return PriceList.class.getSimpleName();
    }

    public PriceList toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommercePriceList commercePriceList = this._commercePriceListService.getCommercePriceList(((Long)dtoConverterContext.getId()).longValue());
        final CommerceCurrency commerceCurrency = commercePriceList.getCommerceCurrency();
        final String priceListStatusLabel = WorkflowConstants.getStatusLabel((int)commercePriceList.getStatus());
        Locale locale = dtoConverterContext.getLocale();
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
        final String priceListStatusLabelI18n = LanguageUtil.get((ResourceBundle)resourceBundle, (String)WorkflowConstants.getStatusLabel((int)commercePriceList.getStatus()));
        final ExpandoBridge expandoBridge = commercePriceList.getExpandoBridge();
        return new PriceList(){
            {
                this.actions = dtoConverterContext.getActions();
                this.active = !commercePriceList.isInactive();
                this.author = commercePriceList.getUserName();
                this.catalogBasePriceList = commercePriceList.isCatalogBasePriceList();
                this.catalogId = PriceListDTOConverter.this._getCatalogId(commercePriceList);
                this.catalogName = PriceListDTOConverter.this._getCatalogName(commercePriceList);
                this.createDate = commercePriceList.getCreateDate();
                this.currencyCode = commerceCurrency.getCode();
                this.customFields = expandoBridge.getAttributes();
                this.displayDate = commercePriceList.getDisplayDate();
                this.expirationDate = commercePriceList.getExpirationDate();
                this.externalReferenceCode = commercePriceList.getExternalReferenceCode();
                this.id = commercePriceList.getCommercePriceListId();
                this.name = commercePriceList.getName();
                this.netPrice = commercePriceList.isNetPrice();
                this.parentPriceListId = commercePriceList.getParentCommercePriceListId();
                this.priority = commercePriceList.getPriority();
                this.type = PriceList.Type.create((String)commercePriceList.getType());
                this.workflowStatusInfo = PriceListDTOConverter.this._getWorkflowStatusInfo(commercePriceList.getStatus(), priceListStatusLabel, priceListStatusLabelI18n);
            }
        };
    }

    private long _getCatalogId(CommercePriceList commercePriceList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByGroupId(commercePriceList.getGroupId());
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }

    private String _getCatalogName(CommercePriceList commercePriceList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByGroupId(commercePriceList.getGroupId());
        if (commerceCatalog == null) {
            return "";
        }
        return commerceCatalog.getName();
    }

    private Status _getWorkflowStatusInfo(final int statusCode, final String priceListStatusLabel, final String priceListStatusLabelI18n) {
        return new Status(){
            {
                this.code = statusCode;
                this.label = priceListStatusLabel;
                this.label_i18n = priceListStatusLabelI18n;
            }
        };
    }
}

