/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.pricing.internal.dto.v2_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.headless.commerce.admin.pricing.dto.v2_0.Category;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={CategoryDTOConverter.class, DTOConverter.class})
public class CategoryDTOConverter
implements DTOConverter<AssetCategory, Category> {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;

    public String getContentType() {
        return Category.class.getSimpleName();
    }

    public Category toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final AssetCategory assetCategory = this._assetCategoryService.getCategory(((Long)dtoConverterContext.getId()).longValue());
        final AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.getAssetVocabulary(assetCategory.getVocabularyId());
        return new Category(){
            {
                this.id = assetCategory.getCategoryId();
                this.name = assetCategory.getName();
                this.path = assetCategory.getPath(dtoConverterContext.getLocale());
                this.vocabulary = assetVocabulary.getName();
            }
        };
    }
}

