/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.exception.NoSuchOrderTypeException;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeRel;
import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.CommerceOrderTypeRelService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderType;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderTypeChannel;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderTypeChannelDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderTypeChannelResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderTypeChannelResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-type-channel.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderTypeChannelResource.class})
public class OrderTypeChannelResourceImpl
extends BaseOrderTypeChannelResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrderTypeRel)")
    private ModelResourcePermission<CommerceOrderTypeRel> _commerceOrderTypeRelModelResourcePermission;
    @Reference
    private CommerceOrderTypeRelService _commerceOrderTypeRelService;
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderTypeChannelDTOConverter _orderTypeChannelDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteOrderTypeChannel(Long id) throws Exception {
        this._commerceOrderTypeRelService.deleteCommerceOrderTypeRel(id.longValue());
    }

    @Override
    public Page<OrderTypeChannel> getOrderTypeByExternalReferenceCodeOrderTypeChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderType == null) {
            throw new NoSuchOrderTypeException("Unable to find order type with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._commerceOrderTypeRelService.getCommerceOrderTypeCommerceChannelRels(commerceOrderType.getCommerceOrderTypeId(), null, pagination.getStartPosition(), pagination.getEndPosition()), commerceOrderTypeRel -> this._toOrderTypeChannel(commerceOrderTypeRel.getCommerceOrderTypeRelId())), (Pagination)pagination, (long)this._commerceOrderTypeRelService.getCommerceOrderTypeCommerceChannelRelsCount(commerceOrderType.getCommerceOrderTypeId(), null));
    }

    @Override
    @NestedField(parentClass=OrderType.class, value="orderTypeChannels")
    public Page<OrderTypeChannel> getOrderTypeIdOrderTypeChannelsPage(Long id, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchCommerceOrderType(id.longValue());
        if (commerceOrderType == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of(this.transform(this._commerceOrderTypeRelService.getCommerceOrderTypeCommerceChannelRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), commerceOrderTypeRel -> this._toOrderTypeChannel(commerceOrderTypeRel.getCommerceOrderTypeRelId())), (Pagination)pagination, (long)this._commerceOrderTypeRelService.getCommerceOrderTypeCommerceChannelRelsCount(id.longValue(), search));
    }

    @Override
    public OrderTypeChannel postOrderTypeByExternalReferenceCodeOrderTypeChannel(String externalReferenceCode, OrderTypeChannel orderTypeChannel) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceOrderType == null) {
            throw new NoSuchOrderTypeException("Unable to find order type with external reference code " + externalReferenceCode);
        }
        return this._addCommerceOrderTypeChannelRel(commerceOrderType.getCommerceOrderTypeId(), orderTypeChannel);
    }

    @Override
    public OrderTypeChannel postOrderTypeIdOrderTypeChannel(Long id, OrderTypeChannel orderTypeChannel) throws Exception {
        return this._addCommerceOrderTypeChannelRel(id, orderTypeChannel);
    }

    private OrderTypeChannel _addCommerceOrderTypeChannelRel(long commerceOrderTypeId, OrderTypeChannel orderTypeChannel) throws Exception {
        CommerceChannel commerceChannel = null;
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        if (Validator.isNull((String)orderTypeChannel.getChannelExternalReferenceCode())) {
            commerceChannel = this._commerceChannelService.getCommerceChannel(orderTypeChannel.getChannelId().longValue());
        } else {
            commerceChannel = this._commerceChannelService.fetchByExternalReferenceCode(orderTypeChannel.getChannelExternalReferenceCode(), serviceContext.getCompanyId());
            if (commerceChannel == null) {
                throw new NoSuchChannelException("Unable to find channel with external reference code " + orderTypeChannel.getChannelExternalReferenceCode());
            }
        }
        CommerceOrderTypeRel commerceOrderTypeRel = this._commerceOrderTypeRelService.addCommerceOrderTypeRel(CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), commerceOrderTypeId, serviceContext);
        return this._toOrderTypeChannel(commerceOrderTypeRel.getCommerceOrderTypeRelId());
    }

    private Map<String, Map<String, String>> _getActions(CommerceOrderTypeRel commerceOrderTypeRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceOrderTypeRel.getCommerceOrderTypeRelId(), "deleteOrderTypeChannel", this._commerceOrderTypeRelModelResourcePermission)).build();
    }

    private OrderTypeChannel _toOrderTypeChannel(Long commerceOrderTypeRelId) throws Exception {
        CommerceOrderTypeRel commerceOrderTypeRel = this._commerceOrderTypeRelService.getCommerceOrderTypeRel(commerceOrderTypeRelId.longValue());
        return this._orderTypeChannelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceOrderTypeRel), this._dtoConverterRegistry, (Object)commerceOrderTypeRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

