/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.order.rule.exception.NoSuchCOREntryException;
import com.liferay.commerce.order.rule.model.COREntry;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.order.rule.service.COREntryService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRule;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleOrderType;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderRuleOrderTypeDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderRuleOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderRuleOrderTypeResource;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-rule-order-type.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderRuleOrderTypeResource.class})
public class OrderRuleOrderTypeResourceImpl
extends BaseOrderRuleOrderTypeResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference(target="(model.class.name=com.liferay.commerce.order.rule.model.COREntryRel)")
    private ModelResourcePermission<COREntryRel> _corEntryRelModelResourcePermission;
    @Reference
    private COREntryRelService _corEntryRelService;
    @Reference
    private COREntryService _corEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderRuleOrderTypeDTOConverter _orderRuleOrderTypeDTOConverter;

    @Override
    public void deleteOrderRuleOrderType(Long id) throws Exception {
        this._corEntryRelService.deleteCOREntryRel(id.longValue());
    }

    @Override
    public Page<OrderRuleOrderType> getOrderRuleByExternalReferenceCodeOrderRuleOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._corEntryRelService.getCommerceOrderTypeCOREntryRels(corEntry.getCOREntryId(), null, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleOrderType((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getCommerceOrderTypeCOREntryRelsCount(corEntry.getCOREntryId(), null));
    }

    @Override
    @NestedField(parentClass=OrderRule.class, value="orderRuleOrderTypes")
    public Page<OrderRuleOrderType> getOrderRuleIdOrderRuleOrderTypesPage(Long id, String search, Pagination pagination) throws Exception {
        COREntry corEntry = this._corEntryService.fetchCOREntry(id.longValue());
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with ID " + id);
        }
        return Page.of(this.transform(this._corEntryRelService.getCommerceOrderTypeCOREntryRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleOrderType((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getCommerceOrderTypeCOREntryRelsCount(id.longValue(), search));
    }

    @Override
    public OrderRuleOrderType postOrderRuleByExternalReferenceCodeOrderRuleOrderType(String externalReferenceCode, OrderRuleOrderType orderRuleOrderType) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        CommerceOrderType commerceOrderType = this._getCommerceOrderType(orderRuleOrderType);
        return this._toOrderRuleOrderType(this._corEntryRelService.addCOREntryRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), corEntry.getCOREntryId()));
    }

    @Override
    public OrderRuleOrderType postOrderRuleIdOrderRuleOrderType(Long id, OrderRuleOrderType orderRuleOrderType) throws Exception {
        CommerceOrderType commerceOrderType = this._getCommerceOrderType(orderRuleOrderType);
        return this._toOrderRuleOrderType(this._corEntryRelService.addCOREntryRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), id.longValue()));
    }

    private Map<String, Map<String, String>> _getActions(COREntryRel corEntryRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", corEntryRel.getCOREntryRelId(), "deleteOrderRuleOrderType", this._corEntryRelModelResourcePermission)).build();
    }

    private CommerceOrderType _getCommerceOrderType(OrderRuleOrderType orderRuleOrderType) throws Exception {
        CommerceOrderType commerceOrderType = null;
        commerceOrderType = orderRuleOrderType.getOrderTypeId() > 0L ? this._commerceOrderTypeService.getCommerceOrderType(orderRuleOrderType.getOrderTypeId().longValue()) : this._commerceOrderTypeService.fetchByExternalReferenceCode(orderRuleOrderType.getOrderTypeExternalReferenceCode(), this.contextCompany.getCompanyId());
        return commerceOrderType;
    }

    private OrderRuleOrderType _toOrderRuleOrderType(COREntryRel corEntryRel) throws Exception {
        return this._orderRuleOrderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(corEntryRel), this._dtoConverterRegistry, (Object)corEntryRel.getCOREntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

