/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.commerce.order.rule.exception.NoSuchCOREntryException;
import com.liferay.commerce.order.rule.model.COREntry;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.order.rule.service.COREntryService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRule;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleChannel;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderRuleChannelDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderRuleChannelResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderRuleChannelResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-rule-channel.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderRuleChannelResource.class})
public class OrderRuleChannelResourceImpl
extends BaseOrderRuleChannelResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference(target="(model.class.name=com.liferay.commerce.order.rule.model.COREntryRel)")
    private ModelResourcePermission<COREntryRel> _corEntryRelModelResourcePermission;
    @Reference
    private COREntryRelService _corEntryRelService;
    @Reference
    private COREntryService _corEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderRuleChannelDTOConverter _orderRuleChannelDTOConverter;

    @Override
    public void deleteOrderRuleChannel(Long id) throws Exception {
        this._corEntryRelService.deleteCOREntryRel(id.longValue());
    }

    @Override
    public Page<OrderRuleChannel> getOrderRuleByExternalReferenceCodeOrderRuleChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._corEntryRelService.getCommerceChannelCOREntryRels(corEntry.getCOREntryId(), null, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleChannel((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getCommerceChannelCOREntryRelsCount(corEntry.getCOREntryId(), null));
    }

    @Override
    @NestedField(parentClass=OrderRule.class, value="orderRuleChannels")
    public Page<OrderRuleChannel> getOrderRuleIdOrderRuleChannelsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        COREntry corEntry = this._corEntryService.fetchCOREntry(id.longValue());
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with ID " + id);
        }
        return Page.of(this.transform(this._corEntryRelService.getCommerceChannelCOREntryRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleChannel((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getCommerceChannelCOREntryRelsCount(id.longValue(), search));
    }

    @Override
    public OrderRuleChannel postOrderRuleByExternalReferenceCodeOrderRuleChannel(String externalReferenceCode, OrderRuleChannel orderRuleChannel) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        CommerceChannel commerceChannel = this._getCommerceChannel(orderRuleChannel);
        return this._toOrderRuleChannel(this._corEntryRelService.addCOREntryRel(CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), corEntry.getCOREntryId()));
    }

    @Override
    public OrderRuleChannel postOrderRuleIdOrderRuleChannel(Long id, OrderRuleChannel orderRuleChannel) throws Exception {
        CommerceChannel commerceChannel = this._getCommerceChannel(orderRuleChannel);
        return this._toOrderRuleChannel(this._corEntryRelService.addCOREntryRel(CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), id.longValue()));
    }

    private Map<String, Map<String, String>> _getActions(COREntryRel corEntryRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", corEntryRel.getCOREntryRelId(), "deleteOrderRuleChannel", this._corEntryRelModelResourcePermission)).build();
    }

    private CommerceChannel _getCommerceChannel(OrderRuleChannel orderRuleChannel) throws Exception {
        CommerceChannel commerceChannel = null;
        commerceChannel = orderRuleChannel.getChannelId() > 0L ? this._commerceChannelService.getCommerceChannel(orderRuleChannel.getChannelId().longValue()) : this._commerceChannelService.fetchByExternalReferenceCode(orderRuleChannel.getChannelExternalReferenceCode(), this.contextCompany.getCompanyId());
        return commerceChannel;
    }

    private OrderRuleChannel _toOrderRuleChannel(COREntryRel corEntryRel) throws Exception {
        return this._orderRuleChannelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(corEntryRel), this._dtoConverterRegistry, (Object)corEntryRel.getCOREntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

