/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.order.internal.resource.v1_0;

import com.liferay.account.model.AccountGroup;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.commerce.order.rule.exception.NoSuchCOREntryException;
import com.liferay.commerce.order.rule.model.COREntry;
import com.liferay.commerce.order.rule.model.COREntryRel;
import com.liferay.commerce.order.rule.service.COREntryRelService;
import com.liferay.commerce.order.rule.service.COREntryService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRule;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderRuleAccountGroup;
import com.liferay.headless.commerce.admin.order.internal.dto.v1_0.converter.OrderRuleAccountGroupDTOConverter;
import com.liferay.headless.commerce.admin.order.internal.resource.v1_0.BaseOrderRuleAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderRuleAccountGroupResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/order-rule-account-group.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, OrderRuleAccountGroupResource.class})
public class OrderRuleAccountGroupResourceImpl
extends BaseOrderRuleAccountGroupResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference(target="(model.class.name=com.liferay.commerce.order.rule.model.COREntryRel)")
    private ModelResourcePermission<COREntryRel> _corEntryRelModelResourcePermission;
    @Reference
    private COREntryRelService _corEntryRelService;
    @Reference
    private COREntryService _corEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private OrderRuleAccountGroupDTOConverter _orderRuleAccountGroupDTOConverter;

    @Override
    public void deleteOrderRuleAccountGroup(Long id) throws Exception {
        this._corEntryRelService.deleteCOREntryRel(id.longValue());
    }

    @Override
    public Page<OrderRuleAccountGroup> getOrderRuleByExternalReferenceCodeOrderRuleAccountGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._corEntryRelService.getAccountGroupCOREntryRels(corEntry.getCOREntryId(), null, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleAccountGroup((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getAccountGroupCOREntryRelsCount(corEntry.getCOREntryId(), null));
    }

    @Override
    @NestedField(parentClass=OrderRule.class, value="orderRuleAccountGroups")
    public Page<OrderRuleAccountGroup> getOrderRuleIdOrderRuleAccountGroupsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        COREntry corEntry = this._corEntryService.fetchCOREntry(id.longValue());
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with ID " + id);
        }
        return Page.of(this.transform(this._corEntryRelService.getAccountGroupCOREntryRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition()), corEntryRel -> this._toOrderRuleAccountGroup((COREntryRel)corEntryRel)), (Pagination)pagination, (long)this._corEntryRelService.getAccountGroupCOREntryRelsCount(id.longValue(), search));
    }

    @Override
    public OrderRuleAccountGroup postOrderRuleByExternalReferenceCodeOrderRuleAccountGroup(String externalReferenceCode, OrderRuleAccountGroup orderRuleAccountGroup) throws Exception {
        COREntry corEntry = this._corEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (corEntry == null) {
            throw new NoSuchCOREntryException("Unable to find order rule with external reference code " + externalReferenceCode);
        }
        CommerceAccountGroup commerceAccountGroup = this._getCommerceAccountGroup(orderRuleAccountGroup);
        return this._toOrderRuleAccountGroup(this._corEntryRelService.addCOREntryRel(AccountGroup.class.getName(), commerceAccountGroup.getCommerceAccountGroupId(), corEntry.getCOREntryId()));
    }

    @Override
    public OrderRuleAccountGroup postOrderRuleIdOrderRuleAccountGroup(Long id, OrderRuleAccountGroup orderRuleAccountGroup) throws Exception {
        CommerceAccountGroup commerceAccountGroup = this._getCommerceAccountGroup(orderRuleAccountGroup);
        return this._toOrderRuleAccountGroup(this._corEntryRelService.addCOREntryRel(AccountGroup.class.getName(), commerceAccountGroup.getCommerceAccountGroupId(), id.longValue()));
    }

    private Map<String, Map<String, String>> _getActions(COREntryRel corEntryRel) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", corEntryRel.getCOREntryRelId(), "deleteOrderRuleAccountGroup", this._corEntryRelModelResourcePermission)).build();
    }

    private CommerceAccountGroup _getCommerceAccountGroup(OrderRuleAccountGroup orderRuleAccountGroup) throws Exception {
        CommerceAccountGroup commerceAccountGroup = null;
        commerceAccountGroup = orderRuleAccountGroup.getAccountGroupId() > 0L ? this._commerceAccountGroupService.getCommerceAccountGroup(orderRuleAccountGroup.getAccountGroupId().longValue()) : this._commerceAccountGroupService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), orderRuleAccountGroup.getAccountGroupExternalReferenceCode());
        return commerceAccountGroup;
    }

    private OrderRuleAccountGroup _toOrderRuleAccountGroup(COREntryRel corEntryRel) throws Exception {
        return this._orderRuleAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(corEntryRel), this._dtoConverterRegistry, (Object)corEntryRel.getCOREntryRelId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

